/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class FilterTerrain {
    public BufferedImage invert(BufferedImage workImage) {
        BufferedImage img = new BufferedImage(workImage.getWidth(), workImage.getHeight(), 1);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                Color c = new Color(workImage.getRGB(x, y));
                c = new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
                img.setRGB(x, y, c.getRGB());
            }
        }
        return img;
    }

    public BufferedImage filter_terrain(BufferedImage workImage) throws IOException {
        String line;
        String line2;
        BufferedReader br = new BufferedReader(new FileReader("myclasses.txt"));
        TreeMap<Integer, Color> classMap = new TreeMap<Integer, Color>();
        while ((line2 = br.readLine()) != null) {
            StringTokenizer st;
            if (line2.startsWith("#") || (st = new StringTokenizer(line2)).countTokens() < 4) continue;
            int classId = Integer.parseInt(st.nextToken());
            int r = Integer.parseInt(st.nextToken());
            int g = Integer.parseInt(st.nextToken());
            int b = Integer.parseInt(st.nextToken());
            classMap.put(classId, new Color(r, g, b));
        }
        br.close();
        TreeMap<Integer, int[]> minMap = new TreeMap<Integer, int[]>();
        TreeMap<Integer, int[]> maxMap = new TreeMap<Integer, int[]>();
        br = new BufferedReader(new FileReader("signatures.txt"));
        while ((line = br.readLine()) != null) {
            StringTokenizer st;
            if (line.startsWith("#") || (st = new StringTokenizer(line)).countTokens() < 7) continue;
            int classId = Integer.parseInt(st.nextToken());
            int[] min = new int[3];
            int[] max = new int[3];
            min[0] = Integer.parseInt(st.nextToken());
            min[1] = Integer.parseInt(st.nextToken());
            min[2] = Integer.parseInt(st.nextToken());
            max[0] = Integer.parseInt(st.nextToken());
            max[1] = Integer.parseInt(st.nextToken());
            max[2] = Integer.parseInt(st.nextToken());
            minMap.put(classId, min);
            maxMap.put(classId, max);
        }
        br.close();
        int w = workImage.getWidth();
        int h = workImage.getHeight();
        BufferedImage results = new BufferedImage(w, h, 1);
        for (int row = 0; row < h; ++row) {
            for (int col = 0; col < w; ++col) {
                int rgb = workImage.getRGB(col, row);
                int r = (rgb & 0xFF0000) >>> 16;
                int g = (rgb & 0xFF00) >>> 8;
                int b = rgb & 0xFF;
                Color assignedClass = new Color(0, 0, 0);
                Iterator iterator = minMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    if (!FilterTerrain.isBetween(r, g, b, (int[])minMap.get(key), (int[])maxMap.get(key))) continue;
                    assignedClass = (Color)classMap.get(key);
                }
                results.setRGB(col, row, assignedClass.getRGB());
            }
        }
        return results;
    }

    private static boolean isBetween(int r, int g, int b, int[] min, int[] max) {
        return min[0] <= r && r <= max[0] && min[1] <= g && g <= max[1] && min[2] <= b && b <= max[2];
    }
}

