/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.filters;

import com.jhlabs.image.HSBAdjustFilter;
import java.awt.image.BufferedImage;
import java.rmi.server.UID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.openstreetmap.josm.plugins.rasterfilters.filters.Filter;

public class HSBFilterImpl
implements Filter {
    private HSBAdjustFilter hsb = new HSBAdjustFilter();
    private float hFactor;
    private float sFactor;
    private float bFactor;
    private UID id;

    public JsonObject changeFilterState(JsonObject jsonObject) {
        JsonObject jsonObject2 = jsonObject.getJsonObject("hue");
        this.hFactor = (float)jsonObject2.getJsonNumber("value").doubleValue();
        JsonObject jsonObject3 = jsonObject.getJsonObject("saturation");
        this.sFactor = (float)jsonObject3.getJsonNumber("value").doubleValue();
        JsonObject jsonObject4 = jsonObject.getJsonObject("brightness");
        this.bFactor = (float)jsonObject4.getJsonNumber("value").doubleValue();
        return jsonObject;
    }

    public BufferedImage applyFilter(BufferedImage bufferedImage) {
        this.hsb.setHFactor(this.hFactor);
        this.hsb.setSFactor(this.sFactor);
        this.hsb.setBFactor(this.bFactor);
        bufferedImage = this.hsb.filter(bufferedImage, null);
        return bufferedImage;
    }

    public void setId(UID uID) {
        this.id = uID;
    }

    public UID getId() {
        return this.id;
    }

    public String toString() {
        JsonObject jsonObject = Json.createObjectBuilder().add("hFactor", (JsonValue)Json.createObjectBuilder().add("value", (double)this.hFactor).build()).add("sFactor", (JsonValue)Json.createObjectBuilder().add("value", (double)this.sFactor).build()).add("bFactor", (JsonValue)Json.createObjectBuilder().add("value", (double)this.bFactor).build()).build();
        return "from contrast: \n" + jsonObject.toString();
    }
}

