/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.filters;

import com.jhlabs.image.ChromaKeyFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.rmi.server.UID;
import javax.json.JsonObject;
import org.openstreetmap.josm.plugins.rasterfilters.filters.Filter;

public class ColorRangeFilterImpl
implements Filter {
    private ChromaKeyFilter chrKey = new ChromaKeyFilter();
    private double hTolerance = 0.0;
    private double sTolerance = 0.0;
    private double bTolerance = 0.0;
    private UID id;
    private int color;

    public JsonObject changeFilterState(JsonObject jsonObject) {
        JsonObject jsonObject2 = jsonObject.getJsonObject("hue");
        this.hTolerance = jsonObject2.getJsonNumber("value").doubleValue();
        JsonObject jsonObject3 = jsonObject.getJsonObject("saturation");
        this.sTolerance = jsonObject3.getJsonNumber("value").doubleValue();
        JsonObject jsonObject4 = jsonObject.getJsonObject("brightness");
        this.bTolerance = jsonObject4.getJsonNumber("value").doubleValue();
        JsonObject jsonObject5 = jsonObject.getJsonObject("color").getJsonObject("value");
        int n = jsonObject5.getInt("red");
        int n2 = jsonObject5.getInt("green");
        int n3 = jsonObject5.getInt("blue");
        this.color = new Color(n, n2, n3).getRGB();
        return jsonObject;
    }

    public BufferedImage applyFilter(BufferedImage bufferedImage) {
        this.chrKey.setHTolerance((float)this.hTolerance);
        this.chrKey.setSTolerance((float)this.sTolerance);
        this.chrKey.setBTolerance((float)this.bTolerance);
        this.chrKey.setColor(this.color);
        return this.chrKey.filter(bufferedImage, null);
    }

    public void setId(UID uID) {
        this.id = uID;
    }

    public UID getId() {
        return this.id;
    }
}

