/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.filters;

import com.jhlabs.image.RGBAdjustFilter;
import java.awt.image.BufferedImage;
import java.rmi.server.UID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.rasterfilters.filters.Filter;

public class RGBFilterImpl
implements Filter {
    private RGBAdjustFilter mix = new RGBAdjustFilter();
    private float red;
    private float green;
    private float blue;
    private UID id;

    public BufferedImage applyFilter(BufferedImage bufferedImage) {
        this.mix.setRFactor(this.red);
        this.mix.setGFactor(this.green);
        this.mix.setBFactor(this.blue);
        return this.mix.filter(bufferedImage, null);
    }

    public String toString() {
        JsonObject jsonObject = Json.createObjectBuilder().add("red", (JsonValue)Json.createObjectBuilder().add("value", (double)this.red).build()).add("green", (JsonValue)Json.createObjectBuilder().add("value", (double)this.green).build()).add("blue", (JsonValue)Json.createObjectBuilder().add("value", (double)this.blue).build()).build();
        return "from channelMix: \n" + jsonObject.toString();
    }

    public JsonObject changeFilterState(JsonObject jsonObject) {
        if (jsonObject != null) {
            JsonObject jsonObject2 = jsonObject.getJsonObject("red");
            this.setRed((float)jsonObject2.getJsonNumber("value").doubleValue());
            JsonObject jsonObject3 = jsonObject.getJsonObject("green");
            this.setGreen((float)jsonObject3.getJsonNumber("value").doubleValue());
            JsonObject jsonObject4 = jsonObject.getJsonObject("blue");
            this.setBlue((float)jsonObject4.getJsonNumber("value").doubleValue());
            Main.debug((String)(this.id.toString() + " \n" + this.toString()));
            return jsonObject;
        }
        return null;
    }

    public void setId(UID uID) {
        this.id = uID;
    }

    public UID getId() {
        return this.id;
    }

    public void setBlue(float f) {
        this.blue = f;
    }

    public void setGreen(float f) {
        this.green = f;
    }

    public void setRed(float f) {
        this.red = f;
    }
}

