/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.filters;

import com.jhlabs.image.ContrastFilter;
import java.awt.image.BufferedImage;
import java.rmi.server.UID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.openstreetmap.josm.plugins.rasterfilters.filters.Filter;

public class ContrastFilterImpl
implements Filter {
    private ContrastFilter contrastBrightness = new ContrastFilter();
    private float contrast = 1.0f;
    private float brightness = 1.0f;
    private UID id;

    public JsonObject changeFilterState(JsonObject jsonObject) {
        JsonObject jsonObject2 = jsonObject.getJsonObject("contrast");
        this.setContrast((float)jsonObject2.getJsonNumber("value").doubleValue());
        JsonObject jsonObject3 = jsonObject.getJsonObject("brightness");
        this.setBrightness((float)jsonObject3.getJsonNumber("value").doubleValue());
        return jsonObject;
    }

    public BufferedImage applyFilter(BufferedImage bufferedImage) {
        this.contrastBrightness.setBrightness(this.brightness);
        this.contrastBrightness.setContrast(this.contrast);
        bufferedImage = this.contrastBrightness.filter(bufferedImage, null);
        return bufferedImage;
    }

    public String toString() {
        JsonObject jsonObject = Json.createObjectBuilder().add("contrast", (JsonValue)Json.createObjectBuilder().add("value", (double)this.contrast).build()).add("brightness", (JsonValue)Json.createObjectBuilder().add("value", (double)this.brightness).build()).build();
        return "from contrast: \n" + jsonObject.toString();
    }

    public void setId(UID uID) {
        this.id = uID;
    }

    public UID getId() {
        return this.id;
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setContrast(float f) {
        this.contrast = f;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float f) {
        this.brightness = f;
    }
}

