package main

import (
	"encoding/json"
	"io/ioutil"
	"log"
	"os"
	"regexp"
)

type test struct {
	Key    string
	Regexp string
	Match  []string
	Reject []string
}

type testSet struct {
	Tests []test
}

func main() {
	log.SetFlags(log.Ltime)
	var filename string
	if len(os.Args) > 1 {
		filename = os.Args[1]
	} else {
		log.Printf("Usage: regtest <filename>")
		return
	}

	file, err := os.Open(filename)
	bytes, err := ioutil.ReadAll(file)
	if err != nil {
		log.Println(err)
		return
	}
	var tests testSet
	if err := json.Unmarshal(bytes, &tests); err != nil {
		log.Print(err)
		return
	}

	for _, t := range tests.Tests {
		_ = runTest(t)
	}
}

func runTest(t test) (result bool) {
	r := regexp.MustCompile(t.Regexp)
	result = true
	log.Printf("key=%s; regexp=%s", t.Key, r.String())
	for _, m := range t.Match {
		if r.MatchString(m) == false {
			log.Printf("Match failed: '%s'", m)
			result = false
		}
	}
	for _, m := range t.Reject {
		if r.MatchString(m) == true {
			log.Printf("Reject failed: '%s'", m)
			result = false
		}
	}
	return
}
