package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;

import org.openstreetmap.gui.jmapviewer.interfaces.TileSource.TileUpdate;

public class EniroAerialTileSource extends AbstractTMSTileSource {
    private static final String PATTERN = "http://map%s.eniro.no";

    private static final String[] SERVER = { "01", "02", "03", "04" };
    
    private int SERVER_NUM = 0;
    //private static final String HOST_NAME1 = "http://map01.eniro.no";
    private static final String TILES_DIRECTORY = "/geowebcache/service/tms1.0.0/aerial/";
    public EniroAerialTileSource() {
        super("EniroAerial",PATTERN);
    }
    
    @Override
    public String getBaseUrl() {
        String url = String.format(this.baseUrl, new Object[] { SERVER[SERVER_NUM] });
        SERVER_NUM = (SERVER_NUM + 1) % SERVER.length;
        return url;
    }
    
    @Override
    public TileUpdate getTileUpdate() {
        return TileUpdate.IfNoneMatch;
    }
    
    @Override
    public String getExtension() {
        return "jpeg";
    }
    
    @Override
    public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
        int eniroTileY = (1<<zoom)-1 - tiley;
        String tilePath = TILES_DIRECTORY  + zoom + "/" + tilex +"/"+ eniroTileY + "." + getExtension();
        return tilePath;
    }
    
    @Override
    public int getMaxZoom() {
        return 19;
    }

}
