#
# Adds command queue listener that will perform utilsplugin2's AddNodesAtIntersections command after encountering Extrude command
#
# Usage: Run once per JOSM session
#

print
print "[AutoAddIntersections] Startup"

from javax.swing import JOptionPane
from org.openstreetmap.josm import Main
from org.openstreetmap.josm.gui.layer.OsmDataLayer import CommandQueueListener
from org.openstreetmap.josm.tools.I18n import tr
try:
    from org.openstreetmap.josm.plugins.utilsplugin2.actions import AddIntersectionsAction
except ImportError:
    JOptionPane.showMessageDialog(Main.parent, "utilsplugin2 not found.")

extrudeCommandText = tr("Extrude Way")

def getAction():
    """Finds utilsplugin2's AddIntersectionsAction in the menu"""
    if not Main.main or not Main.main.menu:
        return None
    menubar = Main.main.menu
    # try directly first item of fourth menu
    i, j = 4, 1
    menu = menubar.getMenu(i)
    if menu:
        menuitem = menu.getItem(j)
        if menuitem:
            action = menuitem.getAction()
            if action and isinstance(action, AddIntersectionsAction):
                print "[AutoAddIntersections] Action found directly at %d/%d (%s/%s)" % (i, j, menu.getText(), menuitem.getText())
                return action
    # search all menus
    for i in range(0, menubar.getMenuCount()):
        menu = menubar.getMenu(i)
        if menu:
            for j in range(0, menu.getItemCount()):
                menuitem = menu.getItem(j)
                if menuitem:
                    action = menuitem.getAction()
                    if action and isinstance(action, AddIntersectionsAction):
                        print "[AutoAddIntersections] Action found at %d/%d (%s/%s)" % (i, j, menu.getText(), menuitem.getText())
                        return action
    JOptionPane.showMessageDialog(Main.parent, "Add nodes at intersections command not found.")
    return None

undoRedo = Main.main.undoRedo
cmds = undoRedo.commands
action = getAction()

class myCommandQueueListener(CommandQueueListener):
    def commandChanged(self, queueSize, redoSize):
        if queueSize > 0 and redoSize == 0:
            cmdDesc = cmds.getLast().getDescriptionText()
            if extrudeCommandText in cmdDesc:
                print "[AutoAddIntersections] Extrude command detected, performing action"
                action.actionPerformed(None);

mcql = myCommandQueueListener()
undoRedo.addCommandQueueListener(mcql)

print "[AutoAddIntersections] Done"
