/*
 * Decompiled with CFR 0.152.
 */
package josmlaunch;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

class JosmLauncher
extends JFrame
implements PropertyChangeListener {
    JButton start = new JButton("Start JOSM");
    JButton update = new JButton("Update JOSM");
    JTextField opts = new JTextField(50);
    JCheckBox portable = new JCheckBox("Portable insatllation");
    JProgressBar progress = new JProgressBar(0, 100);
    Properties properties = new Properties();
    File jarToRun;
    int availableVersion;
    int currentVersion;
    DownloadTask dt = null;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int val = (Integer)evt.getNewValue();
            this.progress.setValue(val);
            this.progress.setString(String.format("Downloading josm-latest.jar v%d: %d of %d Kb", this.availableVersion, this.dt.downloadedBytes / 1024, this.dt.downloadSize / 1024));
            this.progress.setStringPainted(true);
        }
    }

    public JosmLauncher() {
        this.loadProperties();
        this.setSize(350, 200);
        this.center();
        this.jarToRun = new File("josm-latest.jar");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JosmLauncher.this.saveProperties();
                JosmLauncher.this.launch();
            }
        });
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JosmLauncher.this.updateJar();
            }
        });
        GridLayout gb = new GridLayout(4, 1);
        this.setLayout(gb);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JosmLauncher.this.saveProperties();
                System.exit(0);
            }
        });
        this.add(this.portable);
        this.add(this.opts);
        this.add(this.start);
        this.add(this.update);
    }

    void updateJar() {
        if (this.dt != null) {
            System.out.println("Cancel download");
            this.dt.cancel(true);
            this.onDownloadStopped();
            return;
        }
        if (this.checkFreshVersion(true)) {
            return;
        }
        this.dt = new DownloadTask("http://josm.openstreetmap.de/download/josm-latest.jar");
        this.dt.addPropertyChangeListener(this);
        this.dt.execute();
        this.onDownloadStarted();
    }

    private boolean checkFreshVersion(boolean showMessage) {
        GetVersionTask vt = new GetVersionTask("http://josm.openstreetmap.de/latest");
        vt.execute();
        try {
            this.availableVersion = (Integer)vt.get();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Sorry, can not get JOSM version. There is some connection problem", "Warning", 2);
        }
        this.readVersionFromJar();
        if (this.currentVersion >= this.availableVersion) {
            if (showMessage) {
                JOptionPane.showMessageDialog(this, "Your JOSM version " + this.currentVersion + " does not need updating", "", 1);
            }
            this.start.setText("Start JOSM");
            this.start.setVisible(true);
            this.update.setVisible(false);
            return true;
        }
        if (this.currentVersion > 0) {
            this.start.setText("Start JOSM v" + this.currentVersion);
            this.start.setVisible(true);
            this.update.setText("Update to version " + this.availableVersion);
        } else {
            this.start.setVisible(false);
            this.update.setText("Download JOSM version " + this.availableVersion);
        }
        return false;
    }

    private void onDownloadStopped() {
        this.dt = null;
        this.remove(this.progress);
        this.add((Component)this.start, 2);
        this.update.setText("Update JOSM");
        this.revalidate();
        this.repaint();
    }

    private void onDownloadStarted() {
        this.remove(this.start);
        this.add((Component)this.progress, 2);
        this.update.setText("Cancel download");
        this.revalidate();
        this.repaint();
    }

    String getProperty(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadProperties() {
        FileReader fr = null;
        try {
            fr = new FileReader("launcher.ini");
            this.properties.load(fr);
        }
        catch (FileNotFoundException ex) {
            System.err.println("Properties file is created");
        }
        catch (IOException ex) {
            System.err.println("Can not read properties file");
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ex) {}
        }
        this.opts.setText(this.getProperty("options", "-Xmx1024m"));
        this.portable.setSelected(this.getProperty("portable", "false").equals("true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveProperties() {
        this.properties.setProperty("options", this.opts.getText());
        this.properties.setProperty("portable", String.valueOf(this.portable.isSelected()));
        FileWriter fr = null;
        try {
            fr = new FileWriter("launcher.ini");
            this.properties.store(fr, "");
        }
        catch (IOException ex) {
            System.err.println("Can not write properties file");
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readVersionFromJar() {
        this.currentVersion = 0;
        FileInputStream fis = null;
        if (this.jarToRun == null) {
            return;
        }
        if (!this.jarToRun.exists()) {
            return;
        }
        try {
            ZipEntry ze;
            fis = new FileInputStream(this.jarToRun);
            JarInputStream jis = new JarInputStream(fis);
            String ver = null;
            while ((ze = jis.getNextEntry()) != null) {
                if (!"REVISION".equals(ze.getName())) continue;
                ver = this.readStringFromStream(jis);
                break;
            }
            jis.close();
            int idx = ver.lastIndexOf("Revision: ");
            int idx2 = ver.indexOf("\n", idx);
            ver = ver.substring(idx + 10, idx2).trim();
            try {
                if (ver != null) {
                    this.currentVersion = Integer.parseInt(ver);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            System.out.println("version: " + this.currentVersion);
        }
        catch (IOException ex) {
            System.err.println("Can not read JAR file");
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    String readStringFromStream(InputStream is) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(5000);
            byte[] buffer = new byte[32768];
            int read = is.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = is.read(buffer);
            }
            out.close();
            return out.toString();
        }
        catch (IOException ex) {
            System.err.println("Can not read string from stream");
            return null;
        }
    }

    void launch() {
        try {
            String addOpts = "";
            if (this.portable.isSelected()) {
                addOpts = "-Djosm.home=data";
            }
            String cmd = String.format("java %s %s -jar \"%s\"", this.opts.getText(), addOpts, this.jarToRun.getAbsolutePath());
            Process process = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ex) {
            System.exit(1);
        }
        System.exit(0);
    }

    void center() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
    }

    public static void main(String[] args) {
        JosmLauncher launcher = new JosmLauncher();
        if (!launcher.checkFreshVersion(false)) {
            launcher.setVisible(true);
        } else {
            launcher.launch();
        }
    }

    class DownloadTask
    extends SwingWorker<Void, Void> {
        URLConnection downloadConnection;
        String address;
        int downloadSize;
        int downloadedBytes;
        File file = new File("josm-latest.tmp");

        public DownloadTask(String address) {
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Void doInBackground() throws Exception {
            OutputStream out = null;
            InputStream in = null;
            try {
                URL url = new URL(this.address);
                this.downloadConnection = url.openConnection();
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.setRequestProperty("Host", url.getHost());
                this.downloadConnection.connect();
                this.downloadSize = this.downloadConnection.getContentLength();
                if (this.downloadSize < 3000000) {
                    System.err.println("Suspicious JOSM jar size, no download");
                    Void void_ = null;
                    return void_;
                }
                in = this.downloadConnection.getInputStream();
                out = new FileOutputStream(this.file);
                byte[] buffer = new byte[32768];
                this.downloadedBytes = 0;
                int p1 = 0;
                int p2 = 0;
                int read = in.read(buffer);
                while (read != -1) {
                    out.write(buffer, 0, read);
                    this.downloadedBytes += read;
                    if (this.isCancelled()) {
                        System.err.println("Download cancelled");
                        Void void_ = null;
                        return void_;
                    }
                    p2 = 100 * this.downloadedBytes / this.downloadSize;
                    if (p2 != p1) {
                        this.setProgress(p2);
                        p1 = p2;
                    }
                    read = in.read(buffer);
                }
                out.close();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        protected void done() {
            try {
                if (JosmLauncher.this.jarToRun.exists() && !JosmLauncher.this.jarToRun.renameTo(new File("josm-latest.old"))) {
                    System.err.println("error renaming");
                }
                if (!this.file.renameTo(JosmLauncher.this.jarToRun)) {
                    System.err.println("error renaming2");
                }
                JosmLauncher.this.start.setText("Start JOSM");
                JosmLauncher.this.start.setVisible(true);
                JosmLauncher.this.update.setVisible(false);
                JosmLauncher.this.onDownloadStopped();
            }
            catch (Exception e) {
                System.err.println("Can not rename file josm-latest.tmp -> josm-latest.jar  --> josm-latest.old");
            }
        }
    }

    class GetVersionTask
    extends SwingWorker<Integer, Void> {
        URLConnection downloadConnection;
        String address;
        int downloadSize;
        int downloadedBytes;

        public GetVersionTask(String address) {
            this.address = address;
        }

        @Override
        protected Integer doInBackground() throws Exception {
            try {
                URL url = new URL(this.address);
                this.downloadConnection = url.openConnection();
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.setRequestProperty("Host", url.getHost());
                this.downloadConnection.connect();
                this.downloadSize = this.downloadConnection.getContentLength();
                InputStream in = this.downloadConnection.getInputStream();
                String s = JosmLauncher.this.readStringFromStream(in);
                in.close();
                return Integer.parseInt(s);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

