/*
 * Decompiled with CFR 0.152.
 */
package josmlaunch;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

class JosmLauncher
extends JFrame
implements PropertyChangeListener {
    JButton start = new JButton("---");
    JButton update = new JButton("---");
    JTextField opts = new JTextField(50);
    JCheckBox portable = new JCheckBox("Portable installation");
    JProgressBar progress = new JProgressBar(0, 100);
    JComboBox cbInterval = new JComboBox<String>(new String[]{"7", "14", "30", "3", "1"});
    JComboBox cbTested = new JComboBox<String>(new String[]{"josm-tested", "josm-latest"});
    Properties properties = new Properties();
    int availableVersion;
    int currentVersion;
    boolean versionChecked = false;
    String workDir = "";
    File jarToRun;
    File fileWithNewVersion;
    File backupFile;
    File iniFile;
    DownloadTask dt = null;
    private String updateText;
    private String startText;
    private boolean launchOnDownload;
    private long lastUpdate;
    private long updateInterval;
    static final int CHOOSE = 0;
    static final int DOWNLOADING = 1;
    static final int DOWNLOADONLY = 2;
    static final int STARTONLY = 3;
    int oldState = 0;

    String getJosmAddress() {
        return String.format("http://josm.openstreetmap.de/download/josm-%s.jar", this.cbTested.getSelectedIndex() == 0 ? "tested" : "latest");
    }

    String getVersionCheckAddress() {
        return String.format("http://josm.openstreetmap.de/%s", this.cbTested.getSelectedIndex() == 0 ? "tested" : "latest");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int val = (Integer)evt.getNewValue();
            this.progress.setValue(val);
            if (this.dt != null) {
                this.progress.setString(String.format("Downloading josm-latest.jar v%d: %d of %d Kb", this.availableVersion, this.dt.downloadedBytes / 1024, this.dt.downloadSize / 1024));
            }
            this.progress.setStringPainted(true);
        }
    }

    public JosmLauncher() {
        this.setupDirectories();
        this.loadProperties();
        this.setSize(350, 200);
        this.center();
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JosmLauncher.this.launch();
            }
        });
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JosmLauncher.this.updateJar();
            }
        });
        GridLayout gb = new GridLayout(5, 2);
        this.setLayout(gb);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JosmLauncher.this.saveProperties();
                System.exit(0);
            }
        });
        this.startText = "Start JOSM";
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.portable);
        p.add(this.cbTested);
        this.add(p);
        this.cbTested.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JosmLauncher.this.cbTested.getSelectedIndex() == 1) {
                    JOptionPane.showMessageDialog(JosmLauncher.this, "Josm-latest version (released daily) may have more errors than \"tested\", so be careful!", "Warning", 2);
                }
                JosmLauncher.this.setIntervalList();
                JosmLauncher.this.checkFreshVersion(true);
            }
        });
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Java VM arguments: "));
        p.add(this.opts);
        this.add(p);
        p = new JPanel();
        p.add(new JLabel("Automatic update interval(days): "));
        p.add(this.cbInterval);
        this.add(p);
        this.add(this.start);
        this.add(this.update);
    }

    void updateJar() {
        if (this.dt != null) {
            this.dt.cancel(true);
            this.setUIState(0);
            this.dt = null;
            return;
        }
        if (this.checkFreshVersion(false)) {
            if (this.launchOnDownload) {
                this.launch();
            }
            return;
        }
        this.setVisible(true);
        this.dt = new DownloadTask(this.getJosmAddress());
        this.dt.addPropertyChangeListener(this);
        this.dt.execute();
        this.setUIState(1);
    }

    void setIntervalList() {
        String[] its = this.cbTested.getSelectedIndex() == 1 ? new String[]{"10", "7", "5", "3", "2", "1"} : new String[]{"30", "40", "50", "60"};
        this.cbInterval.removeAllItems();
        for (String s : its) {
            this.cbInterval.addItem(s);
        }
    }

    private boolean checkFreshVersion(boolean checkNow) {
        this.setupDirectories();
        if (!this.versionChecked || checkNow) {
            GetVersionTask vt = new GetVersionTask(this.getVersionCheckAddress());
            vt.execute();
            try {
                this.availableVersion = (Integer)vt.get();
                System.err.printf("Version %d found on server\n", this.availableVersion);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Sorry, can not get JOSM version. There is some connection problem", "Warning", 2);
                this.availableVersion = 0;
            }
            this.updateText = "Update to version " + this.availableVersion;
            this.readVersionFromJar();
            this.versionChecked = true;
        }
        if (this.currentVersion >= this.availableVersion) {
            this.setUIState(3);
            return true;
        }
        if (this.currentVersion > 0) {
            this.setUIState(0);
        } else {
            this.setUIState(2);
        }
        return false;
    }

    String getProperty(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadProperties() {
        FileReader fr = null;
        try {
            fr = new FileReader(this.iniFile);
            this.properties.load(fr);
        }
        catch (FileNotFoundException ex) {
            System.err.println("Properties file is not found, will be created");
        }
        catch (IOException ex) {
            System.err.println("Can not read properties file");
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ex) {}
        }
        this.cbTested.setSelectedIndex(this.getProperty("josm-tested", "true").equals("true") ? 0 : 1);
        this.opts.setText(this.getProperty("options", "-Xmx1024m"));
        this.portable.setSelected(this.getProperty("portable", "false").equals("true"));
        this.lastUpdate = Long.parseLong(this.getProperty("lastUpdate", "0"));
        String ui = this.getProperty("updateInterval", "7");
        this.updateInterval = Long.parseLong(ui);
        this.setIntervalList();
        this.cbInterval.setSelectedItem(String.valueOf(this.updateInterval));
        if (!ui.equals(this.cbInterval.getSelectedItem())) {
            this.cbInterval.addItem(ui);
            this.cbInterval.setSelectedItem(ui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveProperties() {
        this.properties.setProperty("options", this.opts.getText());
        this.properties.setProperty("portable", String.valueOf(this.portable.isSelected()));
        this.properties.setProperty("lastUpdate", String.valueOf(this.lastUpdate));
        this.properties.setProperty("updateInterval", this.cbInterval.getSelectedItem().toString());
        this.properties.setProperty("josm-tested", this.cbTested.getSelectedIndex() == 0 ? "true" : "false");
        FileWriter fr = null;
        try {
            fr = new FileWriter(this.iniFile);
            this.properties.store(fr, "");
        }
        catch (IOException ex) {
            System.err.println("Can not write properties file");
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readVersionFromJar() {
        this.currentVersion = 0;
        FileInputStream fis = null;
        ZipInputStream jis = null;
        if (this.jarToRun == null) {
            return;
        }
        if (!this.jarToRun.exists()) {
            return;
        }
        try {
            ZipEntry ze;
            fis = new FileInputStream(this.jarToRun);
            jis = new JarInputStream(fis);
            String ver = null;
            while ((ze = ((JarInputStream)jis).getNextEntry()) != null) {
                if (!"REVISION".equals(ze.getName())) continue;
                ver = this.readStringFromStream(jis);
                break;
            }
            if (ver == null) {
                System.err.println("Can not determine JAR version");
                return;
            }
            int idx = ver.lastIndexOf("Revision: ");
            int idx2 = ver.indexOf("\n", idx);
            if (idx < 0 || idx2 < 0) {
                System.err.println("Can not parse REVISION file in JAR");
                return;
            }
            ver = ver.substring(idx + 10, idx2).trim();
            try {
                if (ver != null) {
                    this.currentVersion = Integer.parseInt(ver);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            this.startText = "Start JOSM v" + this.currentVersion;
            System.err.println("Jar version: " + this.currentVersion);
        }
        catch (IOException ex) {
            System.err.println("Can not read JAR file");
        }
        finally {
            try {
                if (jis != null) {
                    jis.close();
                }
            }
            catch (IOException ex) {
                System.err.println("can not close");
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                System.err.println("can not close");
            }
        }
    }

    String readStringFromStream(InputStream is) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(5000);
            byte[] buffer = new byte[32768];
            int read = is.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = is.read(buffer);
            }
            out.close();
            return out.toString();
        }
        catch (IOException ex) {
            System.err.println("Can not read string from stream");
            return null;
        }
    }

    private boolean checkAlreadyDownloaded() {
        if (this.fileWithNewVersion.exists()) {
            return this.renameDownloadedFiles();
        }
        return false;
    }

    private void setupDirectories() {
        String path;
        String workDir = this.portable.isSelected() ? "updates" : ((path = System.getenv("APPDATA")) != null ? new File(path, "JOSM/updates").getAbsolutePath() : new File(System.getProperty("user.home"), ".josm/updates").getAbsolutePath());
        String name = "josm-" + (this.cbTested.getSelectedIndex() == 0 ? "tested" : "latest");
        this.fileWithNewVersion = new File(workDir, name + ".new");
        this.fileWithNewVersion.getParentFile().mkdirs();
        this.jarToRun = new File(workDir, name + ".jar");
        this.backupFile = new File(workDir, name + ".old");
        this.iniFile = new File(workDir, "launcher.ini");
    }

    void setLaunchOnDownload(boolean b) {
        this.launchOnDownload = b;
    }

    private void downloadIfNeededAndLaunch() {
        if (System.currentTimeMillis() - this.lastUpdate > this.updateInterval * 24L * 3600L) {
            this.launchOnDownload = true;
            this.updateJar();
        } else {
            this.launch();
        }
    }

    boolean renameDownloadedFiles() {
        this.backupFile.delete();
        if (this.jarToRun.exists() && !this.jarToRun.renameTo(this.backupFile)) {
            System.err.println("error renaming");
            return false;
        }
        if (this.fileWithNewVersion.exists()) {
            this.jarToRun.delete();
            if (!this.fileWithNewVersion.renameTo(this.jarToRun)) {
                System.err.println("error renaming .new -> .jar");
                return false;
            }
            this.fileWithNewVersion.delete();
        }
        return true;
    }

    void launch() {
        this.saveProperties();
        try {
            String addOpts = "";
            if (this.portable.isSelected()) {
                addOpts = String.format("-Djosm.home=\"%s\"", new File(this.workDir, "data").getAbsolutePath());
            }
            String cmd = String.format("java %s %s -jar \"%s\"", this.opts.getText(), addOpts, this.jarToRun.getAbsolutePath());
            Process p = Runtime.getRuntime().exec(cmd);
            Thread.sleep(2000L);
            if (p.exitValue() != 0) {
                System.err.println("Error executing!!!");
                this.jarToRun.delete();
            }
        }
        catch (Exception ex) {
            System.exit(1);
        }
        System.exit(0);
    }

    void center() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
    }

    void setUIState(int state) {
        if (this.oldState != state && this.oldState == 1) {
            this.remove(this.progress);
            this.add((Component)this.start, 3);
            this.update.setText(this.updateText);
            this.validate();
            this.repaint();
        }
        this.oldState = state;
        switch (state) {
            case 0: {
                this.updateText = "Update to version " + this.availableVersion;
                this.start.setVisible(true);
                this.update.setVisible(true);
                break;
            }
            case 3: {
                this.startText = "Start JOSM";
                this.start.setVisible(true);
                this.update.setVisible(false);
                break;
            }
            case 2: {
                this.updateText = "Download JOSM version " + this.availableVersion;
                this.update.setVisible(true);
                this.start.setVisible(false);
                break;
            }
            case 1: {
                this.remove(this.start);
                this.add((Component)this.progress, 3);
                this.updateText = "Cancel download";
                this.validate();
                this.repaint();
            }
        }
        this.start.setText(this.startText);
        this.update.setText(this.updateText);
    }

    public static void main(String[] args) {
        System.setProperty("java.net.useSystemProxies", "true");
        JosmLauncher launcher = new JosmLauncher();
        if (args.length > 0) {
            if ("-c".equals(args[0])) {
                launcher.checkFreshVersion(true);
                launcher.setVisible(true);
                return;
            }
            if ("-r".equals(args[0])) {
                launcher.launch();
                return;
            }
            if ("-u".equals(args[0])) {
                launcher.setLaunchOnDownload(true);
                launcher.updateJar();
            }
        } else if (launcher.checkAlreadyDownloaded()) {
            launcher.launch();
        } else {
            launcher.downloadIfNeededAndLaunch();
        }
    }

    class DownloadTask
    extends SwingWorker<Void, Void> {
        URLConnection downloadConnection;
        String address;
        int downloadSize;
        int downloadedBytes;
        private boolean succesful;

        public DownloadTask(String address) {
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Void doInBackground() throws Exception {
            OutputStream out = null;
            InputStream in = null;
            this.succesful = false;
            try {
                URL url = new URL(this.address);
                this.downloadConnection = url.openConnection();
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.setRequestProperty("Host", url.getHost());
                this.downloadConnection.connect();
                this.downloadSize = this.downloadConnection.getContentLength();
                if (this.downloadSize < 3000000) {
                    System.err.println("Suspicious JOSM jar size, no download");
                    Void void_ = null;
                    return void_;
                }
                in = this.downloadConnection.getInputStream();
                out = new FileOutputStream(JosmLauncher.this.fileWithNewVersion);
                byte[] buffer = new byte[32768];
                this.downloadedBytes = 0;
                int p1 = 0;
                int p2 = 0;
                int read = in.read(buffer);
                while (read != -1) {
                    out.write(buffer, 0, read);
                    this.downloadedBytes += read;
                    if (this.isCancelled()) {
                        System.err.println("Download cancelled");
                        Void void_ = null;
                        return void_;
                    }
                    p2 = 100 * this.downloadedBytes / this.downloadSize;
                    if (p2 != p1) {
                        this.setProgress(p2);
                        p1 = p2;
                    }
                    read = in.read(buffer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Void void_ = null;
                return void_;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {}
                }
            }
            this.succesful = JosmLauncher.this.renameDownloadedFiles();
            return null;
        }

        @Override
        protected void done() {
            JosmLauncher.this.setUIState(JosmLauncher.this.dt.succesful ? 3 : 0);
            JosmLauncher.this.dt = null;
            if (this.succesful) {
                JosmLauncher.this.lastUpdate = System.currentTimeMillis();
            }
            if (JosmLauncher.this.launchOnDownload && this.succesful) {
                JosmLauncher.this.launch();
            }
        }
    }

    class GetVersionTask
    extends SwingWorker<Integer, Void> {
        URLConnection downloadConnection;
        String address;
        int downloadSize;
        int downloadedBytes;

        public GetVersionTask(String address) {
            this.address = address;
        }

        @Override
        protected Integer doInBackground() throws Exception {
            try {
                URL url = new URL(this.address);
                this.downloadConnection = url.openConnection();
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.setRequestProperty("Host", url.getHost());
                this.downloadConnection.connect();
                this.downloadSize = this.downloadConnection.getContentLength();
                InputStream in = this.downloadConnection.getInputStream();
                String s = JosmLauncher.this.readStringFromStream(in);
                in.close();
                return Integer.parseInt(s);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

