package org.openstreetmap.josm.plugins.conflation;

import com.vividsolutions.jump.feature.AbstractBasicFeature;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;


public class OsmFeature extends AbstractBasicFeature {
    private Object[] attributes;
    
    public OsmFeature(OsmPrimitive prim) {
        super(new FeatureSchema());
        Map<String, String> keys = prim.getKeys();
        attributes = new Object[keys.size() + 1];
        getSchema().addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        for (String key : keys.keySet()) {
            getSchema().addAttribute(key, AttributeType.STRING);
            setAttribute(key, keys.get(key));
        }
        JTSConversion conversion = new JTSConversion();
        setGeometry(conversion.convert(prim));
    }

    @Override
    public void setAttributes(Object[] attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setAttribute(int attributeIndex, Object newAttribute) {
        attributes[attributeIndex] = newAttribute;
    }

    @Override
    public Object getAttribute(int i) {
        return attributes[i];
    }

    @Override
    public Object[] getAttributes() {
        return attributes;
    }
}
