package org.openstreetmap.josm.gui.actionsupport;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import org.openstreetmap.josm.Main;
import static org.openstreetmap.josm.tools.I18n.tr;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

/**
 * The panel to nag a user ONCE that he/she has to align imagery.
 * 
 * @author zverik
 */
public class AlignImageryPanel extends JPanel {
    private static final String PREF = "imagery.offsetnagging";

    public AlignImageryPanel() {
        super();
        
        Font font = getFont().deriveFont(Font.PLAIN, 14.0f);
        JLabel nagLabel = new JLabel(tr("Aerial imagery might be misaligned. Please check its offset using GPS tracks!"));
//        JLabel nagLabel = new JLabel(tr("Снимки могут быть смещены. Не забудьте проверить привязку снимков по GPS-трекам!"));
        SaneUrlLabel detailsList = new SaneUrlLabel(tr("http://wiki.openstreetmap.org/wiki/Using_Imagery"), tr("Details..."));
        nagLabel.setFont(font);
        detailsList.setFont(font);
        
//        JButton closeButton = new JButton("X");
        JButton closeButton = new JButton(ImageProvider.get("misc", "black_x"));
        closeButton.setContentAreaFilled(false);
        closeButton.setRolloverEnabled(true);
        closeButton.setBorderPainted(false);
        closeButton.setToolTipText(tr("Hide this message and never show it again"));
        closeButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed( ActionEvent e ) {
                setVisible(false);
                getParent().remove(AlignImageryPanel.this);
            }
        });
        
        BoxLayout box = new BoxLayout(this, BoxLayout.X_AXIS);
        setLayout(box);
        add(nagLabel);
        add(Box.createHorizontalStrut(12));
        add(detailsList);
        add(Box.createHorizontalGlue());
        add(closeButton);
//        setBorder(new EmptyBorder(12, 12, 12, 12));
        setBorder(new CompoundBorder(new EtchedBorder(EtchedBorder.LOWERED), new EmptyBorder(12, 12, 12, 12)));
        setBackground(new Color(224, 236, 249));
    }
    
    public static void addNagPanel() {
        if( Main.map != null && !Main.pref.getBoolean("expert") && Main.pref.getBoolean(PREF, true) ) {
            if( Main.map.mapView != null && Main.map.mapView.getParent() instanceof JSplitPane ) {
                // This is really a hack. If you don't like it, use the line in "else" block
                JPanel p = new JPanel(new BorderLayout());
                ((JSplitPane)Main.map.mapView.getParent()).setLeftComponent(p);
                p.add(Main.map.mapView, BorderLayout.CENTER);
                p.add(new AlignImageryPanel(), BorderLayout.NORTH);
            } else
                Main.map.add(new AlignImageryPanel(), BorderLayout.NORTH);
            Main.pref.put(PREF, false);
        }
    }
    
    public static class SaneUrlLabel extends JLabel implements MouseListener {
        private String url;
        
        public SaneUrlLabel( String url, String description ) {
            this.url = url;
            if( url != null ) {
                setText("<html><a href=\"" + url + "\">" + description + "</a></html>");
            } else {
                setText(description);
            }
            setToolTipText(String.format("<html>%s<br/>%s</html>", url, tr("Right click = copy to clipboard")));
            setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            addMouseListener(this);
        }
        
        @Override
        public void mouseClicked( MouseEvent e ) {
            if( SwingUtilities.isLeftMouseButton(e) ) {
                OpenBrowser.displayUrl(url);
            } else if( SwingUtilities.isRightMouseButton(e) ) {
                Utils.copyToClipboard(url);
            }
        }

        @Override public void mousePressed( MouseEvent e ) { }
        @Override public void mouseEntered( MouseEvent e ) { }
        @Override public void mouseExited( MouseEvent e ) { }
        @Override public void mouseReleased( MouseEvent e ) { }
    }
}
