/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.dumbutils;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceGeometryAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Replace Geometry", (Object[])new Object[0]);
    private static final double MAX_NODE_REPLACEMENT_DISTANCE = 3.0E-4;

    public ReplaceGeometryAction() {
        super(TITLE, "dumbutils/replacegeometry", I18n.tr((String)"Replace geometry of selected object with a new one", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:replacegeometry", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{TITLE}), (int)71, (int)1, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (ReplaceGeometryAction.getCurrentDataSet() == null) {
            return;
        }
        ArrayList selection = new ArrayList(ReplaceGeometryAction.getCurrentDataSet().getSelected());
        if (selection.size() != 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This tool replaces geometry of one object with another, and so requires exactly two objects to be selected.", (Object[])new Object[0]), TITLE, 1);
            return;
        }
        OsmPrimitive firstObject = (OsmPrimitive)selection.get(0);
        OsmPrimitive secondObject = (OsmPrimitive)selection.get(1);
        if (firstObject instanceof Way && secondObject instanceof Way) {
            this.replaceWayWithWay(Arrays.asList((Way)firstObject, (Way)secondObject));
        } else if (firstObject instanceof Node && secondObject instanceof Way) {
            this.replaceNodeWithWay((Node)firstObject, (Way)secondObject);
        } else if (secondObject instanceof Node && firstObject instanceof Way) {
            this.replaceNodeWithWay((Node)secondObject, (Way)firstObject);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This tool can only replace a node with a way, or a way with a way.", (Object[])new Object[0]), TITLE, 1);
            return;
        }
    }

    public void replaceNodeWithWay(Node node, Way way) {
        if (!node.getReferrers().isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Node has referrers, cannot replace with way.", (Object[])new Object[0]), TITLE, 1);
            return;
        }
        Node nodeToReplace = null;
        if (!node.isNew()) {
            Collection<Node> nodePool = this.getUnimportantNodes(way);
            nodeToReplace = this.findNearestNode(node, nodePool);
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        AbstractMap nodeTags = (AbstractMap)node.getKeys();
        List<Command> tagResolutionCommands = this.getTagConflictResolutionCommands((OsmPrimitive)node, (OsmPrimitive)way);
        if (tagResolutionCommands == null) {
            return;
        }
        commands.addAll(tagResolutionCommands);
        if (nodeToReplace != null) {
            List wayNodes = way.getNodes();
            int idx = wayNodes.indexOf(nodeToReplace);
            wayNodes.set(idx, node);
            if (idx == 0 && way.isClosed()) {
                wayNodes.set(wayNodes.size() - 1, node);
            }
            commands.add(new ChangeNodesCommand(way, wayNodes));
            commands.add(new MoveCommand(node, nodeToReplace.getCoor()));
            commands.add(new DeleteCommand((OsmPrimitive)nodeToReplace));
            if (!nodeTags.isEmpty()) {
                HashMap<String, Object> nodeTagsToDelete = new HashMap<String, Object>();
                for (String key : nodeTags.keySet()) {
                    ((AbstractMap)nodeTagsToDelete).put(key, null);
                }
                commands.add(new ChangePropertyCommand(Arrays.asList(node), nodeTagsToDelete));
            }
        } else {
            commands.add(new DeleteCommand((OsmPrimitive)node));
        }
        ReplaceGeometryAction.getCurrentDataSet().setSelected(new PrimitiveId[]{way});
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry for way {0}", (Object[])new Object[]{way.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
    }

    public void replaceWayWithWay(List<Way> selection) {
        int idxNew;
        boolean overrideNewCheck = false;
        int n = idxNew = selection.get(0).isNew() ? 0 : 1;
        if (selection.get(1 - idxNew).isNew()) {
            boolean areNewNodes = false;
            for (Node n2 : selection.get(0).getNodes()) {
                if (!n2.isNew()) continue;
                areNewNodes = true;
            }
            idxNew = areNewNodes ? 0 : 1;
            overrideNewCheck = true;
            for (Node n2 : selection.get(1 - idxNew).getNodes()) {
                if (!n2.isNew()) continue;
                overrideNewCheck = false;
            }
        }
        Way geometry = selection.get(idxNew);
        Way way = selection.get(1 - idxNew);
        if (!(overrideNewCheck || !way.isNew() && geometry.isNew())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select one way that exists in the database and one new way with correct geometry.", (Object[])new Object[0]), TITLE, 2);
            return;
        }
        Collection<Node> nodePool = this.getUnimportantNodes(way);
        HashSet<Node> geometryPool = new HashSet<Node>();
        for (Node node : geometry.getNodes()) {
            List referrers = node.getReferrers();
            if (!node.isNew() || node.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)geometry) || way.containsNode(node)) continue;
            geometryPool.add(node);
        }
        HashMap<Node, Node> nodeAssoc = new HashMap<Node, Node>();
        for (Node n3 : geometryPool) {
            Node nearest = this.findNearestNode(n3, nodePool);
            if (nearest == null) continue;
            nodeAssoc.put(n3, nearest);
            nodePool.remove(nearest);
        }
        for (Node n3 : geometryPool) {
            if (!nodeAssoc.containsKey(n3)) continue;
            nodePool.add(n3);
        }
        List geometryNodes = geometry.getNodes();
        for (int i = 0; i < geometryNodes.size(); ++i) {
            if (!nodeAssoc.containsKey(geometryNodes.get(i))) continue;
            geometryNodes.set(i, nodeAssoc.get(geometryNodes.get(i)));
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(new ChangeNodesCommand(way, geometryNodes));
        for (Node node : nodeAssoc.keySet()) {
            commands.add(new MoveCommand((Node)nodeAssoc.get(node), node.getCoor()));
        }
        commands.addAll(this.getTagConflictResolutionCommands((OsmPrimitive)geometry, (OsmPrimitive)way));
        ReplaceGeometryAction.getCurrentDataSet().clearSelection(new PrimitiveId[]{geometry});
        commands.add(new DeleteCommand((OsmPrimitive)geometry));
        if (!nodePool.isEmpty()) {
            commands.add(new DeleteCommand(nodePool));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry for way {0}", (Object[])new Object[]{way.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
    }

    public Collection<Node> getUnimportantNodes(Way way) {
        HashSet<Node> nodePool = new HashSet<Node>();
        Area a = ReplaceGeometryAction.getCurrentDataSet().getDataSourceArea();
        for (Node n : way.getNodes()) {
            List referrers = n.getReferrers();
            if (n.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)way) || !n.isNewOrUndeleted() && a != null && !a.contains((Point2D)n.getCoor())) continue;
            nodePool.add(n);
        }
        return nodePool;
    }

    public List<Command> getTagConflictResolutionCommands(OsmPrimitive source, OsmPrimitive target) {
        List<OsmPrimitive> primitives = Arrays.asList(source, target);
        Set relationToNodeReferences = RelationToChildReference.getRelationToChildReferences(primitives);
        TagCollection tags = TagCollection.unionOfAllPrimitives(primitives);
        TagConflictResolutionUtil.combineTigerTags((TagCollection)tags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing((TagCollection)tags, primitives);
        TagCollection tagsToEdit = new TagCollection(tags);
        TagConflictResolutionUtil.completeTagCollectionForEditing((TagCollection)tagsToEdit);
        CombinePrimitiveResolverDialog dialog = CombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(tagsToEdit, tags.getKeysWithMultipleValues());
        dialog.getRelationMemberConflictResolverModel().populate((Collection)relationToNodeReferences);
        dialog.setTargetPrimitive(target);
        dialog.prepareDefaultDecisions();
        if (!tags.isApplicableToPrimitive() || relationToNodeReferences.size() > 1) {
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return null;
            }
        }
        return dialog.buildResolutionCommands();
    }

    private Node findNearestNode(Node node, Collection<Node> nodes) {
        if (nodes.contains(node)) {
            return node;
        }
        Node nearest = null;
        double distance = 3.0E-4;
        LatLon coor = node.getCoor();
        for (Node n : nodes) {
            double d = n.getCoor().distance((Point2D)coor);
            if (!(d < distance)) continue;
            distance = d;
            nearest = n;
        }
        return nearest;
    }

    protected void updateEnabledState() {
        if (ReplaceGeometryAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(ReplaceGeometryAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && selection.size() >= 2);
    }
}

