/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectHighwayAction
extends JosmAction {
    public SelectHighwayAction() {
        super(I18n.tr((String)"Select Highway", (Object[])new Object[0]), "selecthighway", I18n.tr((String)"Select highway for the name/ref given", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selecthighway", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Select Highway"}), (int)87, (int)2, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = SelectHighwayAction.getCurrentDataSet().getSelected();
        List selectedWays = OsmPrimitive.getFilteredList((Collection)SelectHighwayAction.getCurrentDataSet().getSelected(), Way.class);
        if (selectedWays.size() == 1) {
            SelectHighwayAction.getCurrentDataSet().setSelected(this.selectNamedRoad((Way)selectedWays.get(0)));
        } else if (selectedWays.size() == 2) {
            SelectHighwayAction.getCurrentDataSet().setSelected(this.selectHighwayBetween((Way)selectedWays.get(0), (Way)selectedWays.get(1)));
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select one or two ways for this action", (Object[])new Object[0]), "Select Highway", 0);
        }
    }

    private Set<Way> selectNamedRoad(Way firstWay) {
        String key;
        HashSet<Way> newWays = new HashSet<Way>();
        String string = key = firstWay.hasKey("name") ? "name" : "ref";
        if (firstWay.hasKey(key)) {
            String value = firstWay.get(key);
            LinkedList<Node> nodeQueue = new LinkedList<Node>();
            nodeQueue.add(firstWay.firstNode());
            while (!nodeQueue.isEmpty()) {
                Node node = (Node)nodeQueue.remove();
                for (Way p : OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class)) {
                    if (newWays.contains(p) || !p.hasKey(key) || !p.get(key).equals(value)) continue;
                    newWays.add(p);
                    nodeQueue.add(p.firstNode().equals((Object)node) ? p.lastNode() : p.firstNode());
                }
            }
        }
        return newWays;
    }

    private Set<Way> selectHighwayBetween(Way firstWay, Way lastWay) {
        int minRank = Math.min(SelectHighwayAction.getHighwayRank((OsmPrimitive)firstWay), SelectHighwayAction.getHighwayRank((OsmPrimitive)lastWay));
        HighwayTree firstTree = new HighwayTree(firstWay, minRank);
        HighwayTree secondTree = new HighwayTree(lastWay, minRank);
        Way intersection = firstTree.getIntersection(secondTree);
        while (intersection == null && (firstTree.canMoveOn() || secondTree.canMoveOn())) {
            firstTree.processNextLevel();
            secondTree.processNextLevel();
            intersection = firstTree.getIntersection(secondTree);
        }
        HashSet<Way> newWays = new HashSet<Way>();
        newWays.addAll(firstTree.getPath(intersection));
        newWays.addAll(secondTree.getPath(intersection));
        return newWays;
    }

    private static int getHighwayRank(OsmPrimitive way) {
        if (!way.hasKey("highway")) {
            return 0;
        }
        String highway = way.get("highway");
        if (highway.equals("path") || highway.equals("footway") || highway.equals("cycleway")) {
            return 1;
        }
        if (highway.equals("track") || highway.equals("service")) {
            return 2;
        }
        if (highway.equals("unclassified") || highway.equals("residential")) {
            return 3;
        }
        if (highway.equals("tertiary") || highway.equals("tertiary_link")) {
            return 4;
        }
        if (highway.equals("secondary") || highway.equals("secondary_link")) {
            return 5;
        }
        if (highway.equals("primary") || highway.equals("primary_link")) {
            return 6;
        }
        if (highway.equals("trunk") || highway.equals("trunk_link") || highway.equals("motorway") || highway.equals("motorway_link")) {
            return 7;
        }
        return 0;
    }

    protected void updateEnabledState() {
        if (SelectHighwayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SelectHighwayAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        int count = 0;
        int rank = 100;
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++count;
            rank = Math.min(rank, SelectHighwayAction.getHighwayRank(osmPrimitive));
        }
        this.setEnabled(count == 1 || count == 2 && rank > 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HighwayTree {
        private List<Way> tree = new ArrayList<Way>(1);
        private List<Integer> refs = new ArrayList<Integer>(1);
        private List<Node> nodesToCheck;
        private List<Integer> nodeRefs;
        private int minHighwayRank;

        public HighwayTree(Way from, int minHighwayRank) {
            this.tree.add(from);
            this.refs.add(-1);
            this.minHighwayRank = minHighwayRank;
            this.nodesToCheck = new ArrayList<Node>(2);
            this.nodeRefs = new ArrayList<Integer>(2);
            this.nodesToCheck.add(from.firstNode());
            this.nodesToCheck.add(from.lastNode());
            this.nodeRefs.add(0);
            this.nodeRefs.add(0);
        }

        public void processNextLevel() {
            ArrayList<Node> newNodes = new ArrayList<Node>();
            ArrayList<Integer> newIdx = new ArrayList<Integer>();
            for (int i = 0; i < this.nodesToCheck.size(); ++i) {
                Node node = this.nodesToCheck.get(i);
                Integer nodeRef = this.nodeRefs.get(i);
                for (Way way : OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class)) {
                    if (!way.firstNode().equals((Object)node) && !way.lastNode().equals((Object)node) || this.tree.contains(way) || !this.suits(way)) continue;
                    this.tree.add(way);
                    this.refs.add(nodeRef);
                    Node newNode = way.firstNode().equals((Object)node) ? way.lastNode() : way.firstNode();
                    newNodes.add(newNode);
                    newIdx.add(this.tree.size() - 1);
                }
            }
            this.nodesToCheck = newNodes;
            this.nodeRefs = newIdx;
        }

        private boolean suits(Way w) {
            return SelectHighwayAction.getHighwayRank((OsmPrimitive)w) >= this.minHighwayRank;
        }

        public boolean canMoveOn() {
            return !this.nodesToCheck.isEmpty() && this.tree.size() < 10000;
        }

        public Way getIntersection(HighwayTree other) {
            for (Way w : other.tree) {
                if (!this.tree.contains(w)) continue;
                return w;
            }
            return null;
        }

        public List<Way> getPath(Way to) {
            if (to == null) {
                return Collections.singletonList(this.tree.get(0));
            }
            int pos = this.tree.indexOf(to);
            if (pos < 0) {
                throw new ArrayIndexOutOfBoundsException("Way " + to + " is not in the tree.");
            }
            ArrayList<Way> result = new ArrayList<Way>(1);
            while (pos >= 0) {
                result.add(this.tree.get(pos));
                pos = this.refs.get(pos);
            }
            return result;
        }
    }
}

