/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import utilsplugin2.AddIntersectionsAction;
import utilsplugin2.ExtractPointAction;
import utilsplugin2.LatLonAction;
import utilsplugin2.SplitObjectAction;
import utilsplugin2.SymmetryAction;
import utilsplugin2.UnGlueRelationAction;
import utilsplugin2.customurl.ChooseURLAction;
import utilsplugin2.customurl.OpenPageAction;
import utilsplugin2.customurl.UtilsPluginPreferences;
import utilsplugin2.dumbutils.AlignWayNodesAction;
import utilsplugin2.dumbutils.PasteRelationsAction;
import utilsplugin2.dumbutils.ReplaceGeometryAction;
import utilsplugin2.dumbutils.SplitOnIntersectionsAction;
import utilsplugin2.dumbutils.TagBufferAction;
import utilsplugin2.dumbutils.TagSourceAction;
import utilsplugin2.selection.AdjacentNodesAction;
import utilsplugin2.selection.AdjacentWaysAction;
import utilsplugin2.selection.ConnectedWaysAction;
import utilsplugin2.selection.IntersectedWaysAction;
import utilsplugin2.selection.IntersectedWaysRecursiveAction;
import utilsplugin2.selection.MiddleNodesAction;
import utilsplugin2.selection.NodeWayUtils;
import utilsplugin2.selection.SelectAllInsideAction;
import utilsplugin2.selection.SelectBoundaryAction;
import utilsplugin2.selection.SelectHighwayAction;
import utilsplugin2.selection.SelectModNodesAction;
import utilsplugin2.selection.SelectModWaysAction;
import utilsplugin2.selection.SelectWayNodesAction;
import utilsplugin2.selection.UndoSelectionAction;
import utilsplugin2.selection.UnselectNodesAction;

public class UtilsPlugin2
extends Plugin {
    JMenuItem unglueRelation;
    JMenuItem symmetry;
    JMenuItem addIntersections;
    JMenuItem splitObject;
    JMenuItem selectWayNodes;
    JMenuItem adjNodes;
    JMenuItem unsNodes;
    JMenuItem midNodes;
    JMenuItem adjWays;
    JMenuItem adjWaysAll;
    JMenuItem intWays;
    JMenuItem intWaysR;
    JMenuItem allInside;
    JMenuItem undoSelection;
    JMenuItem extractPoint;
    JMenuItem wiki;
    JMenuItem latlon;
    JMenuItem replaceGeometry;
    JMenuItem tagBuffer;
    JMenuItem sourceTag;
    JMenuItem pasteRelations;
    JMenuItem alignWayNodes;
    JMenuItem splitOnIntersections;
    JMenuItem selModifiedNodes;
    JMenuItem selModifiedWays;
    JMenuItem selectHighway;
    JMenuItem selectAreaBoundary;
    JMenuItem selectURL;

    public UtilsPlugin2(PluginInformation info) {
        super(info);
        JMenu toolsMenu = Main.main.menu.addMenu(I18n.marktr((String)"More tools"), 82, 4, "help");
        this.unglueRelation = MainMenu.add((JMenu)toolsMenu, (JosmAction)new UnGlueRelationAction());
        this.addIntersections = MainMenu.add((JMenu)toolsMenu, (JosmAction)new AddIntersectionsAction());
        this.splitObject = MainMenu.add((JMenu)toolsMenu, (JosmAction)new SplitObjectAction());
        toolsMenu.addSeparator();
        this.replaceGeometry = MainMenu.add((JMenu)toolsMenu, (JosmAction)new ReplaceGeometryAction());
        this.tagBuffer = MainMenu.add((JMenu)toolsMenu, (JosmAction)new TagBufferAction());
        this.sourceTag = MainMenu.add((JMenu)toolsMenu, (JosmAction)new TagSourceAction());
        this.pasteRelations = MainMenu.add((JMenu)toolsMenu, (JosmAction)new PasteRelationsAction());
        this.alignWayNodes = MainMenu.add((JMenu)toolsMenu, (JosmAction)new AlignWayNodesAction());
        this.splitOnIntersections = MainMenu.add((JMenu)toolsMenu, (JosmAction)new SplitOnIntersectionsAction());
        this.extractPoint = MainMenu.add((JMenu)toolsMenu, (JosmAction)new ExtractPointAction());
        this.symmetry = MainMenu.add((JMenu)toolsMenu, (JosmAction)new SymmetryAction());
        this.wiki = MainMenu.add((JMenu)toolsMenu, (JosmAction)new OpenPageAction());
        this.latlon = MainMenu.add((JMenu)toolsMenu, (JosmAction)new LatLonAction());
        MainMenu mainMenu = Main.main.menu;
        String string = I18n.marktr((String)"Selection");
        Main.main.menu.getClass();
        JMenu selectionMenu = mainMenu.addMenu(string, 78, 7, "help");
        this.selectWayNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectWayNodesAction());
        this.adjNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new AdjacentNodesAction());
        this.unsNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new UnselectNodesAction());
        this.midNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new MiddleNodesAction());
        this.adjWays = MainMenu.add((JMenu)selectionMenu, (JosmAction)new AdjacentWaysAction());
        this.adjWaysAll = MainMenu.add((JMenu)selectionMenu, (JosmAction)new ConnectedWaysAction());
        this.intWays = MainMenu.add((JMenu)selectionMenu, (JosmAction)new IntersectedWaysAction());
        this.intWaysR = MainMenu.add((JMenu)selectionMenu, (JosmAction)new IntersectedWaysRecursiveAction());
        this.allInside = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectAllInsideAction());
        this.selModifiedNodes = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectModNodesAction());
        this.selModifiedWays = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectModWaysAction());
        this.undoSelection = MainMenu.add((JMenu)selectionMenu, (JosmAction)new UndoSelectionAction());
        this.selectHighway = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectHighwayAction());
        this.selectAreaBoundary = MainMenu.add((JMenu)selectionMenu, (JosmAction)new SelectBoundaryAction());
        this.selectURL = MainMenu.add((JMenu)toolsMenu, (JosmAction)new ChooseURLAction());
        SearchCompiler.addMatchFactory((SearchCompiler.MatchFactory)new UtilsUnaryMatchFactory());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        boolean enabled = newFrame != null;
        enabled = false;
        this.unglueRelation.setEnabled(enabled);
        this.addIntersections.setEnabled(enabled);
        this.splitObject.setEnabled(enabled);
        this.replaceGeometry.setEnabled(enabled);
        this.tagBuffer.setEnabled(enabled);
        this.sourceTag.setEnabled(enabled);
        this.pasteRelations.setEnabled(enabled);
        this.alignWayNodes.setEnabled(enabled);
        this.splitOnIntersections.setEnabled(enabled);
        this.wiki.setEnabled(enabled);
        this.selectWayNodes.setEnabled(enabled);
        this.adjNodes.setEnabled(enabled);
        this.unsNodes.setEnabled(enabled);
        this.midNodes.setEnabled(enabled);
        this.adjWays.setEnabled(enabled);
        this.adjWaysAll.setEnabled(enabled);
        this.intWays.setEnabled(enabled);
        this.intWaysR.setEnabled(enabled);
        this.selModifiedNodes.setEnabled(enabled);
        this.selModifiedWays.setEnabled(enabled);
        this.undoSelection.setEnabled(enabled);
        this.selectURL.setEnabled(enabled);
        this.allInside.setEnabled(enabled);
    }

    public PreferenceSetting getPreferenceSetting() {
        return new UtilsPluginPreferences();
    }

    public static class IntersectingMatch
    extends SearchCompiler.UnaryMatch {
        private Collection<Way> intersecting = null;

        public IntersectingMatch(SearchCompiler.Match match, boolean all) {
            super(match);
            this.init(all);
        }

        private void init(boolean all) {
            HashSet<Way> matchedWays = new HashSet<Way>();
            Collection allWays = Main.main.getCurrentDataSet().getWays();
            for (Way way : allWays) {
                if (!this.match.match((OsmPrimitive)way)) continue;
                matchedWays.add(way);
            }
            HashSet<Way> newWays = new HashSet<Way>();
            if (all) {
                NodeWayUtils.addWaysIntersectingWaysRecursively(allWays, matchedWays, newWays);
            } else {
                NodeWayUtils.addWaysIntersectingWays(allWays, matchedWays, newWays);
            }
            this.intersecting = newWays;
        }

        public boolean match(OsmPrimitive osm) {
            return this.intersecting.contains(osm);
        }
    }

    public static class InsideMatch
    extends SearchCompiler.UnaryMatch {
        private Collection<OsmPrimitive> inside = null;

        public InsideMatch(SearchCompiler.Match match) {
            super(match);
            this.init();
        }

        private void init() {
            HashSet<OsmPrimitive> matchedAreas = new HashSet<OsmPrimitive>();
            Collection ways = Main.main.getCurrentDataSet().getWays();
            for (Way way : ways) {
                if (!this.match.match((OsmPrimitive)way)) continue;
                matchedAreas.add((OsmPrimitive)way);
            }
            Collection rels = Main.main.getCurrentDataSet().getRelations();
            for (Relation rel : rels) {
                if (!this.match.match((OsmPrimitive)rel)) continue;
                matchedAreas.add((OsmPrimitive)rel);
            }
            this.inside = NodeWayUtils.selectAllInside(matchedAreas, Main.main.getCurrentDataSet());
        }

        public boolean match(OsmPrimitive osm) {
            return this.inside.contains(osm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UtilsUnaryMatchFactory
    implements SearchCompiler.UnaryMatchFactory {
        private static Collection<String> keywords = Arrays.asList("inside", "intersecting", "allintersecting");

        public SearchCompiler.UnaryMatch get(String keyword, SearchCompiler.Match matchOperand, PushbackTokenizer tokenizer) throws SearchCompiler.ParseError {
            if ("inside".equals(keyword)) {
                return new InsideMatch(matchOperand);
            }
            if ("intersecting".equals(keyword)) {
                return new IntersectingMatch(matchOperand, false);
            }
            if ("allintersecting".equals(keyword)) {
                return new IntersectingMatch(matchOperand, true);
            }
            return null;
        }

        public Collection<String> getKeywords() {
            return keywords;
        }
    }
}

