/**
 * 
 */
package org.openstreetmap.gui.jmapviewer.scene;

import java.awt.Graphics;
import java.util.Vector;

import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.scene.entities.MapObject;

/**
 * Starting off with a really simple scene graph for rendering 2D
 * objects.
 * 
 * @author Jason Huntley
 *
 */
public class MapScene {
    protected Vector<MapObject> mapObjectList;
    private JMapViewer view = null;

    public MapScene(JMapViewer view) {
        mapObjectList = new Vector<MapObject>();
        this.view=view;
    }

    /**
     * @return the view
     */
    public JMapViewer getView() {
        return view;
    }

    public void addMapObject(MapObject obj) {
        obj.initialize(getView());
        mapObjectList.add(obj);
    }

    public void removeMapObject(MapObject obj) {
        mapObjectList.remove(obj);
    }

    public void drawScene(Graphics g) {
        for (MapObject object : mapObjectList) {
            object.update(view);
            object.draw(g, getView());
        }
    }

    public void clear() {
        mapObjectList.clear();
    }
}
