package org.openstreetmap.gui.jmapviewer.scene.entities;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

import org.openstreetmap.gui.jmapviewer.interfaces.MapViewInterface;


public class MapLabel extends MapObject {
    private String label="";
    private Color color = Color.black;
    private Font font = new Font("SanSerif", Font.BOLD, 12);

    public MapLabel(String label) {
        super();
        this.label=label;
    }

    @Override
    public void initialize(MapViewInterface view) {

    }

    /**
     * @return the font
     */
    public Font getFont() {
        return font;
    }

    /**
     * @param font the font to set
     */
    public void setFont(Font font) {
        this.font = font;
    }

    /**
     * @param color the color to set
     */
    public void setColor(Color color) {
        this.color = color;
    }

    /**
     * @return the color
     */
    public Color getColor() {
        return color;
    }

    @Override
    protected void drawObject(Graphics2D g2, AffineTransform at) {
        g2.setFont(font);
        g2.setColor(color);
        g2.drawString(label, (int)at.getTranslateX(), (int)at.getTranslateY());
    }
}
