/**
 * 
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author Jason Huntley
 *
 */
public class XMLTileParseUtil {
	public static Element getElement(Document doc, String elementName) {
		return getElement(doc, null, elementName);
	}
	
	public static Element getElement(Document doc, Element parentElement, String elmentName) {
		Element element = null;
		NodeList list= null;
		
		if (parentElement!=null) {
			list=parentElement.getElementsByTagName(elmentName);
		} else {
			list=doc.getElementsByTagName(elmentName);
		}
		
		if ((list!=null) && (list.getLength()>0)) {
			Node n = list.item(0);
			
			if ((n!=null) && (n.getNodeType() == Node.ELEMENT_NODE)){
				element = (Element)n;
			}
		}
		
		return element;
	}
	
	public static String getNodeStrValue(Node n) {
    	if ((n!=null) && (n.getNodeType() == Node.ELEMENT_NODE)){
    		return ((Element)n).getFirstChild().getNodeValue();
    	}  	
    	
    	return "";
	}
	
	public static Integer getNodeIntValue(Node n) {
    	if ((n!=null) && (n.getNodeType() == Node.ELEMENT_NODE)){
    		String value=((Element)n).getFirstChild().getNodeValue();
    		
    		if ((value!=null) && !value.isEmpty())
    			return Integer.parseInt(value);
    	}  	
    	
    	return null;
	}
	
	public static Double getNodeDblValue(Node n) {
    	if ((n!=null) && (n.getNodeType() == Node.ELEMENT_NODE)){
    		String value=((Element)n).getFirstChild().getNodeValue();
    		
    		if ((value!=null) && !value.isEmpty())
    			return Double.parseDouble(value);
    	}  	
    	
    	return null;
	}
}
