// License: GPL. For details, see LICENSE file.
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;

public class NmeaReader {

	/**
	 * The resulting gpx data
	 */
	public GpxData data;
	public enum state { init, metadata, wpt, rte, trk, ext, author, link, trkseg }

	/**
	 * Parse the input stream and store the result in trackData and markerData
	 * 
	 * @param relativeMarkerPath The directory to use as relative path for all &lt;wpt&gt; 
	 *    marker tags. Maybe <code>null</code>, in which case no relative urls are constructed for the markers. 
	 */
	public NmeaReader(InputStream source, File relativeMarkerPath) throws IOException {
		
		BufferedReader reader = new BufferedReader( new InputStreamReader(source));
		ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>();
		int latdeg,londeg;
		double latmin,lonmin;
		LatLon ll;
		String line=null;
		while((line = reader.readLine())!=null){
			if(line.startsWith("$GPRMC")){
				// Parse in:
				/* GPRMC,191410,A,4735.5634,N,00739.3538,E,0.0,0.0,181102,0.4,E,A*19
				         ^      ^ ^           ^            ^   ^   ^      ^     ^ ^
				         |      | |           |            |   |   |      |     | |
				         |      | |           |            |   |   |      |     | Checksum
				         |      | |           |            |   |   |      |     |
				         |      | |           |            |   |   |      |     Mode (A,D,E,N,S)
				         |      | |           |            |   |   |      |
				         |      | |           |            |   |   |      magnetic
				         |      | |           |            |   |   |      Declination 0.4 E
				         |      | |           |            |   |   |
				         |      | |           |            |   |   Datum: 18.11.02
				         |      | |           |            |   |
				         |      | |           |            |   Heading (without motion: 0)
				         |      | |           |            |
				         |      | |           |            Speed over ground (Knots)
				         |      | |           |
				         |      | |           longitude 007 39.3538' East
				         |      | |
				         |      | latitude 47 35.5634' North
				         |      |
				         |      Receiver warning, A = Data OK, V = Warning
				         |
				         19:14:10 UTC time */
				try {
	                String[] parts = line.split(",");
	                if("A".equals(parts[2])){
	                	latdeg=Integer.parseInt(parts[3].substring(0,2));
	                	if("S".equals(parts[4]))
	                		latdeg=-latdeg;
	                	latmin=Double.parseDouble(parts[3].substring(2));
	                	
	                	londeg=Integer.parseInt(parts[5].substring(0,3));
	                	if("W".equals(parts[6]))
	                		londeg=-londeg;
	                	lonmin=Double.parseDouble(parts[5].substring(3));
	                	
	                	ll=new LatLon(latdeg+latmin/60,londeg+lonmin/60);
	                	WayPoint wp = new WayPoint(ll);
	                	waypoints.add(wp);
	                }
                } catch (NumberFormatException e) {
                }
			}
		}
		GpxTrack track = new GpxTrack();
		track.trackSegs.add(waypoints);
		ArrayList<GpxTrack>tracks=new ArrayList<GpxTrack>();
		tracks.add(track);
		data=new GpxData();
		data.tracks=tracks;
	}
}
