package provagl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;

import javax.swing.JComponent;

public class MySwingCanvas extends JComponent {

	private static final long serialVersionUID = 1L;
	
	private int lineNum;
	private int polyNum;
	private int vertexPolyNum;

	public MySwingCanvas(int ln, int pn, int vpn) {
		super();
		this.setVisible(true);
			
		this.lineNum = ln;
		this.polyNum = pn;
		this.vertexPolyNum = vpn;
	}
	
	public void paint(Graphics g) {
		int width = this.getWidth();
		int height = this.getHeight();
		
		//System.err.println(width + " " + height);
		
		g.setColor(Color.BLACK);
		g.fillRect(0, 0, width, height);
		g.setColor(new Color(50, 200, 120));
		long startTime = System.currentTimeMillis();
		for (int i = 0; i < lineNum; i++) {
			g.drawLine((int) (Math.random()*width), (int) (Math.random()*height), (int) (Math.random()*width), (int) (Math.random()*height));
		}
		long endTime = System.currentTimeMillis();
		
		long elapsed = endTime - startTime;
		System.err.println("Swing:");
		System.err.println("Line number: " + lineNum);
		System.err.println("Time elapsed: " + elapsed + " ms");
		System.err.println("Time per line: " + ((double) elapsed) / ((double) lineNum) + " ms/line");
		
		startTime = System.currentTimeMillis();
		Polygon p = new Polygon();
		for (int i = 0; i < this.polyNum; i++) {
			for (int j = 0; j < this.vertexPolyNum; j++) {
				p.addPoint((int) (Math.random()*width), (int) (Math.random()*height));
			}
			g.fillPolygon(p);
		}
		endTime = System.currentTimeMillis();
		
		elapsed = endTime - startTime;
		System.err.println("Polys Swing:");
		System.err.println("Poly number: " + polyNum);
		System.err.println("Time elapsed: " + elapsed + " ms");
		System.err.println("Time per poly: " + ((double) elapsed) / ((double) polyNum) + " ms/poly");
	}
	
	public Dimension getPreferredSize() {
		return new Dimension(100,100);
		
	}

}
