package provagl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;

public class MyGLCanvas extends GLCanvas implements GLEventListener {

	private static final long serialVersionUID = 1L;
	
	private int lineNum;
	private int polyNum;
	private int vertexPolyNum;
	
	MyGLCanvas(int ln, int pn, int vpn) {
		this.addGLEventListener(this);
		this.setVisible(true);
		
		this.lineNum = ln;
		this.polyNum = pn;
		this.vertexPolyNum = vpn;
	}

	public void display(GLAutoDrawable drawable) {
		System.out.println("display()");
		
		GL gl = drawable.getGL();
		
		gl.glColor3d(0.0, 0.0, 0.0);
		gl.glBegin(GL.GL_QUADS);
		gl.glVertex2d(-1.0, -1.0);
		gl.glVertex2d(1.0, -1.0);
		gl.glVertex2d(1.0, 1.0);
		gl.glVertex2d(-1.0, 1.0);
		gl.glEnd();
		gl.glColor3d(0.2, 0.9, 0.5);
		long startTime = System.currentTimeMillis();
		gl.glBegin(GL.GL_LINES);
		for (int i = 0; i < lineNum; i++) {
			gl.glVertex2d(Math.random() * 2 - 1, Math.random() * 2 - 1);
			gl.glVertex2d(Math.random() * 2 - 1, Math.random() * 2 - 1);
		}
		gl.glEnd();
		long endTime = System.currentTimeMillis();
		
		long elapsed = endTime - startTime;
		System.err.println("Lines GL:");
		System.err.println("Line number: " + lineNum);
		System.err.println("Time elapsed: " + elapsed + " ms");
		System.err.println("Time per line: " + ((double) elapsed) / ((double) lineNum) + " ms/line");
		
		startTime = System.currentTimeMillis();
		for (int i = 0; i < this.polyNum; i++) {
			gl.glBegin(GL.GL_POLYGON);
			for (int j = 0; j < this.vertexPolyNum; j++) {
				gl.glVertex2d(Math.random() * 2 - 1, Math.random() * 2 - 1);
			}
			gl.glEnd();
		}
		endTime = System.currentTimeMillis();
		
		elapsed = endTime - startTime;
		System.err.println("Polys GL:");
		System.err.println("Poly number: " + polyNum);
		System.err.println("Time elapsed: " + elapsed + " ms");
		System.err.println("Time per poly: " + ((double) elapsed) / ((double) polyNum) + " ms/poly");
	}

	public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
		System.out.println("displayChanges()");
	}

	public void init(GLAutoDrawable drawable) {
		System.out.println("init()");
		
	    GL gl = drawable.getGL();

	    System.err.println("INIT GL IS: " + gl.getClass().getName());
	    System.err.println("Chosen GLCapabilities: " + drawable.getChosenGLCapabilities());
	    System.err.println("GL_VENDOR: " + gl.glGetString(GL.GL_VENDOR));
	    System.err.println("GL_RENDERER: " + gl.glGetString(GL.GL_RENDERER));
	    System.err.println("GL_VERSION: " + gl.glGetString(GL.GL_VERSION));

	    //gl.setSwapInterval(1);
	}

	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		System.out.println("reshape()");
		
		GL gl = drawable.getGL();
		
		gl.glMatrixMode(GL.GL_PROJECTION);
		gl.glLoadIdentity();
		gl.glOrtho(-1, 1, -1, 1, -1, 1);
		
		gl.glMatrixMode(GL.GL_MODELVIEW);
		gl.glLoadIdentity();
	}
	
}
