package provagl;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ProvaGL implements ActionListener {
	
	private Component canvasGL;
	private Component canvasSwing;
	
	private JButton buttonGL;
	private JButton buttonSwing;
	
	ProvaGL() {
		this.canvasGL = new MyGLCanvas(100000, 100, 40);
		this.canvasSwing = new MySwingCanvas(100000, 20, 40);
		
		JFrame jf = new JFrame();
		jf.setTitle("Control");
		jf.setSize(250, 100);
		jf.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
				System.exit(0);
			}
		});
		JPanel jp = new JPanel(new FlowLayout());
		jp.setVisible(true);
		jf.setContentPane(jp);
		this.buttonGL = new JButton("Refresh GL");
		this.buttonSwing = new JButton("Refresh Swing");
		this.buttonGL.addActionListener(this);
		this.buttonSwing.addActionListener(this);
		this.buttonGL.setVisible(true);
		this.buttonSwing.setVisible(true);
		jp.add(this.buttonGL);
		jp.add(this.buttonSwing);
		jf.setVisible(true);
		
		createFrame(canvasGL, "GL");
		createFrame(canvasSwing, "Swing");
	}
	
	void createFrame(Component canvas, String title) {
		JFrame jf = new JFrame();
		jf.setTitle("Benchmark: " + title);
		jf.setSize(640, 480);
		jf.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
				System.exit(0);
			}
		});
		JPanel jp = new JPanel(new GridLayout(1,0));
		jp.setVisible(true);
		jf.setContentPane(jp);
		jp.add(canvas);
		jf.setVisible(true);
	}

	public static void main(String[] args) {
		@SuppressWarnings("unused")
		ProvaGL pgl = new ProvaGL();
	}

	public void actionPerformed(ActionEvent ae) {
		if (ae.getSource() == this.buttonGL) {
			this.canvasGL.repaint();
		} else if (ae.getSource() == this.buttonSwing) {
			this.canvasSwing.repaint();
		}
	}

}
