import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.util.Map.Entry;
import java.util.List;
import java.util.zip.*;
import java.io.*;
import java.net.*;

import javax.script.*;

public class TestJS2 {

    public static class API {
        public static void hi() {
            System.out.println("ho");
        }
    }

    public static void main(String[] args) {


        ScriptEngineManager mgr = new ScriptEngineManager();

        ScriptEngine jsEngine = mgr.getEngineByName("rhino");

        Map<String, String> map = new HashMap<String, String>();
        map.put("key1", "value1");
        map.put("key2", "value2");
        Map<String, List<String>> lists = new HashMap<String, List<String>>();
        lists.put("lkey1", Arrays.asList("first", "list"));
        lists.put("lkey2", Arrays.asList("second", "list"));

        jsEngine.put("map", map);
        jsEngine.put("lists", lists);
        jsEngine.put("_API", new API());

        String init =
            "API = {};"+
            "API.hi = _API.hi;"+
            "API.pref = {};"+
            "for (it = map.entrySet().iterator(); it.hasNext();) {"+
            "  e = it.next();"+
            "  API.pref[String(e.getKey())] = String(e.getValue());"+
            "}"+
            "for (it = lists.entrySet().iterator(); it.hasNext();) {"+
            "  e = it.next();"+
            "  list = e.getValue();"+
            "  jsList = [];"+
            "  for (i = 0; i < list.size(); i++) {"+
            "    jsList.push(String(list.get(i)));"+
            "  }"+
            "  jsList.type = 'list';"+
            "  API.pref[String(e.getKey())] = jsList;"+
            "}"+
            "map = null; lists = null;";

        String script =
            "API.hi();"+
            "API.pref['key3'] = 'value3';"+
            "API.pref['lkey2'].push('another');";

        String finish =
            "map = new java.util.HashMap;"+
            "lists = new java.util.HashMap;"+
            "for (key in API.pref) {"+
            "  val = API.pref[key];"+
            "  type = typeof val == 'string' ? 'string' : val.type;"+
            "  if (type == 'string') {"+
            "    map.put(key, val);"+
            "  } else if (type == 'list') {"+
            "    l = new java.util.ArrayList;"+
            "    for (i=0; i<val.length; i++) {"+
            "      l.add(val[i]);"+
            "    }"+
            "    lists.put(key, l);"+
            "  }"+
            "}";
        try {
            System.out.println("Running init...");
            jsEngine.eval(init);
            System.out.println("Running script...");
            jsEngine.eval(script);
            System.out.println("Running finish...");
            jsEngine.eval(finish);
            Map<String, String> map2 = (HashMap) jsEngine.get("map");
            Map<String, List<String>> lists2 = (HashMap) jsEngine.get("lists");;

            System.out.println("map2: "+map2);
            System.out.println("lists2: "+lists2);
        } catch (ScriptException ex) {
            ex.printStackTrace();
        }
    }
}