import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.util.List;
import java.util.zip.*;
import java.io.*;
import java.net.*;

import javax.script.*;

public class TestJS {
    public static void main(String[] args) {


        ScriptEngineManager mgr = new ScriptEngineManager();

        ScriptEngine jsEngine = mgr.getEngineByName("rhino");

        Map<String, String> map = new HashMap<String, String>();
        map.put("key1", "value1");
        map.put("key2", "value2");
        Map<String, List<String>> lists = new HashMap<String, List<String>>();
        lists.put("lkey1", Arrays.asList("first", "list"));
        lists.put("lkey2", Arrays.asList("second", "list"));

        jsEngine.put("map", map);
        jsEngine.put("lists", lists);

        String init =
            "pref = {};"+
            "for (it = map.entrySet().iterator(); it.hasNext();) {"+
            "  e = it.next();"+
            "  pref[String(e.getKey())] = String(e.getValue());"+
            "}"+
            "for (it = lists.entrySet().iterator(); it.hasNext();) {"+
            "  e = it.next();"+
            "  list = e.getValue();"+
            "  jsList = [];"+
            "  for (i = 0; i < list.size(); i++) {"+
            "    jsList.push(String(list.get(i)));"+
            "  }"+
            "  jsList.type = 'list';"+
            "  pref[String(e.getKey())] = jsList;"+
            "}"+
            "map = null; lists = null;";

        String script =
            "for (key in pref) {"+
            "  val = pref[key];"+
            "  type = typeof val == 'string' ? 'string' : val.type;"+
            "  println('key: '+key+' value-type: '+type+' value: '+val);"+
            "}"+
            "pref['key3'] = 'value3';";

        try {
            System.out.println("Running init...");
            jsEngine.eval(init);
            System.out.println("Running script...");
            jsEngine.eval(script);
        } catch (ScriptException ex) {
            ex.printStackTrace();
        }
    }
}