// License: GPL. For details, see LICENSE file.
package org.openstreetmap.josm.actions;

import static org.openstreetmap.josm.tools.I18n.tr;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.tools.Shortcut;

public class LassoModeAction extends JosmAction {

    public LassoModeAction() {
        super(tr("Toggle Selection Mode"),
                "rope32",
                tr("Toggle Selection Mode (Rectangle Mode / Lasso Mode)"),
                Shortcut.registerShortcut("mapmode:toggleselectmode", tr("Mode: {0}", tr("Toogle Selection Mode")), KeyEvent.VK_A, Shortcut.GROUP_EDIT, Shortcut.SHIFT_DEFAULT),
                true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MapMode mapMode = Main.map.mapMode;

        if (mapMode instanceof SelectAction) {
            SelectAction selectAction = (SelectAction) mapMode;
            selectAction.setLassoMode(!selectAction.isLassoMode());
        }
    }

}
