import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;

public class Test {

    public static void main(String[] args) {
        
        Map<String, String> map = new HashMap<String, String>();
        
        try  {
            InputStreamReader ir = new InputStreamReader(new FileInputStream("D:\\Users\\Vincent\\Desktop\\JOSM_work\\gottic.osm"), "UTF-8");
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(ir);
            
            int event = parser.getEventType();
            while (true) {
                if (event == XMLStreamConstants.START_ELEMENT) {
                    String key = parser.getAttributeValue(null, "k");
                    String value = parser.getAttributeValue(null, "v");
                    if (key != null && value != null) {
                        map.put(key.intern(), value.intern());
                    }
                }
                if (parser.hasNext()) {
                    event = parser.next();
                } else {
                    break;
                }
            }
            parser.close();
            
            String value = map.get("name:ch");
            System.out.println("From XML chinese:" + Arrays.toString(value.getBytes("UTF-8")));

            value = new String(Character.toChars(0x24B62));
            System.out.println("Expected chinese:" + Arrays.toString(value.getBytes("UTF-8")));

            value = map.get("name:got");
            System.out.println("From XML gothic:" + Arrays.toString(value.getBytes("UTF-8")));
            
            value = new String(Character.toChars(0x10330));
            System.out.println("Expected gothic:" + Arrays.toString(value.getBytes("UTF-8")));
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
