/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class EdigeoRecord {
    final String name;
    final Nature nature;
    final Format format;
    final int length;
    final List<String> values;

    EdigeoRecord(String line) {
        this.name = line.substring(0, 3);
        assert ('A' <= this.name.charAt(0) && this.name.charAt(0) <= 'Z') : line;
        this.nature = Nature.of(line.charAt(3));
        this.format = Format.of(line.charAt(4));
        assert (this.nature != Nature.RESERVED || this.format == Format.RESERVED) : line;
        this.length = Integer.parseUnsignedInt(line.substring(5, 7));
        assert (line.charAt(7) == ':') : line;
        if (line.length() > 8) {
            assert (line.length() <= 80);
            this.values = Arrays.asList(line.substring(8).split(";"));
            assert (this.nature == Nature.RESERVED || this.nature == Nature.SIMPLE && this.values.size() == 1 || this.nature == Nature.COMPOSED && this.values.size() > 1) : line;
        } else {
            this.values = Collections.emptyList();
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.length, this.nature, this.name, this.values});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EdigeoRecord other = (EdigeoRecord)obj;
        return this.format == other.format && this.length == other.length && this.nature == other.nature && Objects.equals(this.name, other.name) && Objects.equals(this.values, other.values);
    }

    public String toString() {
        return "EdigeoRecord [name=" + this.name + ", nature=" + String.valueOf((Object)this.nature) + ", format=" + String.valueOf((Object)this.format) + ", length=" + this.length + ", values=" + String.valueOf(this.values) + "]";
    }

    static enum Nature {
        RESERVED('T'),
        SIMPLE('S'),
        COMPOSED('C');

        final char code;

        private Nature(char code) {
            this.code = code;
        }

        static Nature of(char c) {
            for (Nature n : Nature.values()) {
                if (c != n.code) continue;
                return n;
            }
            throw new IllegalArgumentException(Character.toString(c));
        }
    }

    static enum Format {
        STRING('A'),
        BINARY('B'),
        COORDINATES('C'),
        DATE('D'),
        REAL_WITH_EXP('E'),
        SIGNED('I'),
        UNSIGNED('N'),
        DESCRIPTOR_REF('P'),
        REAL_WITHOUT_EXP('R'),
        TEXT('T'),
        RESERVED(' ');

        final char code;

        private Format(char code) {
            this.code = code;
        }

        static Format of(char c) {
            for (Format f : Format.values()) {
                if (c != f.code) continue;
                return f;
            }
            throw new IllegalArgumentException(Character.toString(c));
        }
    }
}

