/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MenuActionSaveRasterAs
extends JosmAction {
    private static final String NAME = I18n.marktr((String)"Save image as...");
    private final transient WMSLayer wmsLayer;
    FiltreTiff filtreTiff = new FiltreTiff();
    FiltrePng filtrePng = new FiltrePng();

    public MenuActionSaveRasterAs(WMSLayer wmsLayer) {
        super(I18n.tr((String)NAME, (Object[])new Object[0]), "save", I18n.tr((String)"Export image (only raster images)", (Object[])new Object[0]), null, false);
        this.wmsLayer = wmsLayer;
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(this.filtreTiff);
        fc.addChoosableFileFilter(this.filtrePng);
        fc.setFileFilter(this.filtreTiff);
        int returnVal = fc.showSaveDialog((Component)MainApplication.getMainFrame());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            BufferedImage bi = this.wmsLayer.getImage((int)0).image;
            if (fc.getFileFilter().equals(this.filtrePng)) {
                if (!file.getName().endsWith(".png")) {
                    file = new File(file.getParent(), file.getName() + ".png");
                }
                try {
                    ImageIO.write((RenderedImage)bi, "png", file);
                }
                catch (IOException e) {
                    Logging.error((Throwable)e);
                }
            } else if (fc.getFileFilter().equals(this.filtreTiff)) {
                boolean alpha = bi.getColorModel().hasAlpha();
                Logging.info((String)("image with alpha channel : " + alpha));
                try {
                    double x = this.wmsLayer.getImage((int)0).min.east();
                    double y = this.wmsLayer.getImage((int)0).min.north();
                    ReferencedEnvelope bbox = ReferencedEnvelope.rect((double)x, (double)y, (double)(this.wmsLayer.getImage((int)0).max.east() - x), (double)(this.wmsLayer.getImage((int)0).max.north() - y), (CoordinateReferenceSystem)CRS.decode((String)"EPSG:27561"));
                    GridCoverageFactory factory = new GridCoverageFactory();
                    GridCoverage2D coverage = factory.create((CharSequence)"tiff", (RenderedImage)bi, (Bounds)bbox);
                    File output = new File(file.getParent(), file.getName() + ".tif");
                    GeoTiffWriter gtwriter = new GeoTiffWriter((Object)output);
                    GeoTiffWriteParams wp = new GeoTiffWriteParams();
                    wp.setCompressionMode(2);
                    wp.setCompressionType("LZW");
                    wp.setCompressionQuality(0.75f);
                    GeoTiffFormat format = new GeoTiffFormat();
                    ParameterValueGroup params = format.getWriteParameters();
                    params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
                    gtwriter.write((GridCoverage)coverage, params.values().toArray(new GeneralParameterValue[1]));
                    gtwriter.dispose();
                    coverage.dispose(true);
                }
                catch (IOException | FactoryException e) {
                    Logging.error((Throwable)e);
                }
            }
        }
    }

    static class FiltreTiff
    extends FileFilter
    implements Serializable {
        FiltreTiff() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase(Locale.ENGLISH).endsWith(".tif");
        }

        @Override
        public String getDescription() {
            return I18n.tr((String)"GeoTiff files (*.tif)", (Object[])new Object[0]);
        }
    }

    static class FiltrePng
    extends FileFilter
    implements Serializable {
        FiltrePng() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase(Locale.ENGLISH).endsWith(".png");
        }

        @Override
        public String getDescription() {
            return I18n.tr((String)"PNG files (*.png)", (Object[])new Object[0]);
        }
    }
}

