/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.utils.ClassToInstancesMap;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.utils.MutableClassToInstancesMap;

public abstract class EdigeoLotFile<B extends EdigeoFileTHF.ChildBlock>
extends EdigeoFile {
    protected final EdigeoFileTHF.Lot lot;
    protected final String subsetId;
    private final Map<String, Class<? extends B>> classes = new HashMap<String, Class<? extends B>>();
    protected final ClassToInstancesMap<B> blocks = new MutableClassToInstancesMap();

    EdigeoLotFile(EdigeoFileTHF.Lot lot, String subsetId, Path path) {
        super(path);
        this.lot = Objects.requireNonNull(lot, "lot");
        this.subsetId = Objects.requireNonNull(subsetId, "subsetId");
    }

    protected final void register(String key, Class<? extends B> klass) {
        this.classes.put(key, klass);
        this.blocks.putInstances(klass, new ArrayList());
    }

    @Override
    protected final EdigeoFile.Block createBlock(String type) throws ReflectiveOperationException {
        Class<B> klass = this.classes.get(type);
        return EdigeoLotFile.addBlock((List)this.blocks.get(klass), (EdigeoFileTHF.ChildBlock)klass.getDeclaredConstructor(EdigeoFileTHF.Lot.class, String.class).newInstance(this.lot, type));
    }

    @Override
    public EdigeoLotFile<B> read() throws IOException, ReflectiveOperationException {
        super.read();
        return this;
    }

    @Override
    final boolean isValid() {
        return this.blocks.values().stream().allMatch(l -> l.stream().allMatch(EdigeoFile.Block::isValid));
    }

    @Override
    final void resolve() {
        this.blocks.forEach((k, v) -> v.forEach(EdigeoFile.Block::resolvePhase1));
        this.blocks.forEach((k, v) -> v.forEach(EdigeoFile.Block::resolvePhase2));
    }

    public final B find(List<String> values) {
        assert (values.size() == 4) : values;
        return this.find(values, this.classes.get(values.get(2)));
    }

    public final <T extends B> T find(List<String> values, Class<T> klass) {
        assert (values.size() == 4) : values;
        assert (values.get(0).equals(this.lot.identifier)) : String.valueOf(values) + " / " + this.lot.identifier;
        assert (values.get(1).equals(this.subsetId)) : String.valueOf(values) + " / " + this.subsetId;
        assert (klass.isAssignableFrom(this.classes.get(values.get(2)))) : values;
        List<Object> list = this.blocks.getInstances(klass);
        if (list == null) {
            Class<? extends B> realClass = this.classes.get(values.get(2));
            if (klass.isAssignableFrom(realClass)) {
                list = this.blocks.getInstances(realClass);
            } else {
                throw new IllegalArgumentException(String.valueOf(values) + " / " + String.valueOf(klass) + " / " + String.valueOf(realClass));
            }
        }
        return (T)list.stream().filter(x -> x.identifier.equals(values.get(3))).findAny().orElseThrow(() -> new IllegalArgumentException(String.valueOf(values) + " / " + String.valueOf(klass)));
    }
}

