/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileDIC;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoLotFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoRecord;

public class EdigeoFileSCD
extends EdigeoLotFile<ScdBlock> {
    public EdigeoFileSCD(EdigeoFileTHF.Lot lot, String seId, Path path) throws IOException {
        super(lot, seId, path);
        this.register("OBJ", McdObjectDef.class);
        this.register("ATT", McdAttributeDef.class);
        this.register("PGE", McdPrimitiveDef.class);
        this.register("ASS", McdSemanticRelationDef.class);
        this.register("REL", McdConstructionRelationDef.class);
        lot.scd = this;
    }

    public static class McdObjectDef
    extends ScdTaggedDef {
        EdigeoFileDIC.ObjectDef dictRef;
        ObjectKind kind;

        McdObjectDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "DIP": {
                    this.dictRef = this.lot.dic.find(r.values, EdigeoFileDIC.ObjectDef.class);
                    break;
                }
                case "KND": {
                    this.safeGet(r, (String s) -> {
                        this.kind = ObjectKind.of(s);
                    });
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && McdObjectDef.areNotNull(new Object[]{this.dictRef, this.kind});
        }

        public String toString() {
            return "McdObjectDef [dictRef=" + String.valueOf(this.dictRef) + ", kind=" + String.valueOf((Object)this.kind) + ", nAttributes=" + this.nAttributes + ", attributes=" + String.valueOf(this.attributes) + ", nQualities=" + this.nQualities + ", type=" + this.type + ", identifier=" + this.identifier + "]";
        }

        static enum ObjectKind {
            COMPLEX("CPX"),
            POINT("PCT"),
            LINE("LIN"),
            AREA("ARE");

            final String code;

            private ObjectKind(String code) {
                this.code = code;
            }

            public static ObjectKind of(String code) {
                for (ObjectKind s : ObjectKind.values()) {
                    if (!s.code.equals(code)) continue;
                    return s;
                }
                throw new IllegalArgumentException(code);
            }
        }
    }

    public static class McdAttributeDef
    extends ScdBlock {
        EdigeoFileDIC.AttributeDef dictRef;
        int nMaxChars;
        int nMaxDigits;
        int nMaxExponent;
        String unit = "";
        String min = "";
        String max = "";

        McdAttributeDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "DIP": {
                    this.dictRef = this.lot.dic.find(r.values, EdigeoFileDIC.AttributeDef.class);
                    break;
                }
                case "CAN": {
                    this.nMaxChars = this.safeGetInt(r);
                    break;
                }
                case "CAD": {
                    this.nMaxDigits = this.safeGetInt(r);
                    break;
                }
                case "CAE": {
                    this.nMaxExponent = this.safeGetInt(r);
                    break;
                }
                case "UNI": {
                    this.safeGet(r, (String s) -> {
                        this.unit = this.unit + s;
                    });
                    break;
                }
                case "AV1": {
                    this.safeGet(r, (String s) -> {
                        this.min = this.min + s;
                    });
                    break;
                }
                case "AV2": {
                    this.safeGet(r, (String s) -> {
                        this.max = this.max + s;
                    });
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && McdAttributeDef.areNotNull(this.dictRef);
        }

        public String toString() {
            return "McdAttributeDef [identifier=" + this.identifier + "]";
        }
    }

    public static class McdPrimitiveDef
    extends ScdTaggedDef {
        PrimitiveKind kind;

        McdPrimitiveDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "KND": {
                    this.safeGet(r, (String s) -> {
                        this.kind = PrimitiveKind.of(s);
                    });
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && McdPrimitiveDef.areNotNull(new Object[]{this.kind});
        }

        public String toString() {
            return "McdPrimitiveDef [kind=" + String.valueOf((Object)this.kind) + ", nAttributes=" + this.nAttributes + ", attributes=" + String.valueOf(this.attributes) + ", nQualities=" + this.nQualities + ", type=" + this.type + ", identifier=" + this.identifier + "]";
        }

        static enum PrimitiveKind {
            NODE("NOD"),
            ARC("ARC"),
            FACE("FAC");

            final String code;

            private PrimitiveKind(String code) {
                this.code = code;
            }

            public static PrimitiveKind of(String code) {
                for (PrimitiveKind s : PrimitiveKind.values()) {
                    if (!s.code.equals(code)) continue;
                    return s;
                }
                throw new IllegalArgumentException(code);
            }
        }
    }

    public static class McdSemanticRelationDef
    extends McdRelationDef {
        EdigeoFileDIC.RelationDef dictRef;

        McdSemanticRelationDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "DIP": {
                    this.dictRef = this.lot.dic.find(r.values, EdigeoFileDIC.RelationDef.class);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && McdSemanticRelationDef.areNotNull(this.dictRef);
        }

        public String toString() {
            return "McdSemanticRelationDef [dictRef=" + String.valueOf(this.dictRef) + ", minCardinal=" + this.minCardinal + ", maxCardinal=" + this.maxCardinal + ", scdRef=" + String.valueOf(this.scdRef) + ", nOccurences=" + String.valueOf(this.nOccurences) + ", attributes=" + String.valueOf(this.attributes) + ", type=" + this.type + ", identifier=" + this.identifier + "]";
        }
    }

    public static class McdConstructionRelationDef
    extends McdRelationDef {
        RelationKind kind;

        McdConstructionRelationDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "KND": {
                    this.safeGet(r, (String s) -> {
                        this.kind = RelationKind.of(s);
                    });
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && McdConstructionRelationDef.areNotNull(new Object[]{this.kind});
        }

        public String toString() {
            return "McdConstructionRelationDef [kind=" + String.valueOf((Object)this.kind) + ", minCardinal=" + this.minCardinal + ", maxCardinal=" + this.maxCardinal + ", scdRef=" + String.valueOf(this.scdRef) + ", nOccurences=" + String.valueOf(this.nOccurences) + ", attributes=" + String.valueOf(this.attributes) + ", type=" + this.type + ", identifier=" + this.identifier + "]";
        }

        static enum RelationKind {
            IS_COMPOSED_OF("ICO"),
            IS_MADE_OF("IDB"),
            IS_MADE_OF_ARC("IDR"),
            HAS_FOR_INITIAL_NODE("IND"),
            HAS_FOR_FINAL_NODE("FND"),
            HAS_FOR_LEFT_FACE("LPO"),
            HAS_FOR_RIGHT_FACE("RPO"),
            IS_INCLUDED_IN("ILI"),
            BELONG_TO("BET");

            final String code;

            private RelationKind(String code) {
                this.code = code;
            }

            public static RelationKind of(String code) {
                for (RelationKind s : RelationKind.values()) {
                    if (!s.code.equals(code)) continue;
                    return s;
                }
                throw new IllegalArgumentException(code);
            }
        }
    }

    static abstract class McdRelationDef
    extends ScdTaggedDef {
        int minCardinal;
        int maxCardinal;
        int nTypes;
        final List<ScdBlock> scdRef = new ArrayList<ScdBlock>();
        final List<Integer> nOccurences = new ArrayList<Integer>();

        McdRelationDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "CA1": {
                    this.minCardinal = this.safeGetInt(r);
                    break;
                }
                case "CA2": {
                    this.maxCardinal = this.safeGetInt(r);
                    break;
                }
                case "SCC": {
                    this.nTypes = this.safeGetInt(r);
                    break;
                }
                case "SCP": {
                    this.scdRef.add((ScdBlock)this.lot.scd.find(r.values));
                    break;
                }
                case "OCC": {
                    this.nOccurences.add(this.safeGetInt(r));
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && McdRelationDef.areNotNull(this.minCardinal, this.maxCardinal) && McdRelationDef.areSameSize(this.nTypes, this.scdRef, this.nOccurences);
        }
    }

    static abstract class ScdTaggedDef
    extends ScdBlock {
        int nAttributes;
        final List<List<String>> lAttributes = new ArrayList<List<String>>();
        int nQualities;
        final List<McdAttributeDef> attributes = new ArrayList<McdAttributeDef>();

        ScdTaggedDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "AAC": {
                    this.nAttributes = this.safeGetInt(r);
                    break;
                }
                case "AAP": {
                    this.lAttributes.add(r.values);
                    break;
                }
                case "QAC": {
                    this.nQualities = this.safeGetInt(r);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        void resolvePhase1() {
            super.resolvePhase1();
            for (List<String> values : this.lAttributes) {
                this.attributes.add(this.lot.scd.find(values, McdAttributeDef.class));
            }
            this.lAttributes.clear();
        }

        @Override
        boolean isValid() {
            return super.isValid() && ScdTaggedDef.areSameSize(this.nAttributes, this.attributes);
        }
    }

    static abstract class ScdBlock
    extends EdigeoFileTHF.ChildBlock {
        ScdBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }
}

