/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionGrab;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionGrabPlanImage;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionLoadFromCache;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionNewLocation;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionOpenPreferences;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.mapmode.Address;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.mapmode.WMSAdjustAction;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.upload.CheckSourceUploadHook;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreDownloadSource;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreDownloadTask;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.pci.EdigeoPciImporter;
import org.openstreetmap.josm.plugins.fr.cadastre.preferences.CadastrePreferenceSetting;
import org.openstreetmap.josm.plugins.fr.cadastre.session.CadastreSessionExporter;
import org.openstreetmap.josm.plugins.fr.cadastre.session.CadastreSessionImporter;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class CadastrePlugin
extends Plugin {
    static final String VERSION = "3.1";
    static JMenu cadastreJMenu;
    public static String source;
    public static boolean autoSourcing;
    public static boolean pluginUsed;
    public static String cacheDir;
    public static boolean alterColors;
    public static boolean backgroundTransparent;
    public static float transparency;
    public static boolean drawBoundaries;
    public static int imageWidth;
    public static int imageHeight;
    public static String grabLayers;
    public static String grabStyles;
    private static boolean menuEnabled;
    private static final String LAYER_BULDINGS = "CDIF:BATIMENT,CDIF:LS2";
    private static final String STYLE_BUILDING = "BATIMENT_90,LS2_90";
    private static final String LAYER_WATER = "CDIF:LS3";
    private static final String STYLE_WATER = "LS3_90";
    private static final String LAYER_SYMBOL = "CDIF:LS1";
    private static final String STYLE_SYMBOL = "LS1_90";
    private static final String LAYER_PARCELS = "CDIF:PARCELLE";
    private static final String STYLE_PARCELS = "PARCELLE_90";
    private static final String LAYER_NUMERO = "CDIF:NUMERO";
    private static final String STYLE_NUMERO = "NUMERO_90";
    private static final String LAYER_LABEL = "CDIF:PT3,CDIF:PT2,CDIF:PT1";
    private static final String STYLE_LABEL = "PT3_90,PT2_90,PT1_90";
    private static final String LAYER_LIEUDIT = "CDIF:LIEUDIT";
    private static final String STYLE_LIEUDIT = "LIEUDIT_90";
    private static final String LAYER_SECTION = "CDIF:SUBSECTION,CDIF:SECTION";
    private static final String STYLE_SECTION = "SUBSECTION_90,SECTION_90";
    private static final String LAYER_COMMUNE = "CDIF:COMMUNE";
    private static final String STYLE_COMMUNE = "COMMUNE_90";

    public CadastrePlugin(PluginInformation info) {
        super(info);
        Logging.info((String)"Plugin cadastre-fr v3.1 started...");
        CadastrePlugin.initCacheDir();
        CadastrePlugin.refreshConfiguration();
        UploadAction.registerUploadHook((UploadHook)new CheckSourceUploadHook());
        ExtensionFileFilter.addImporter((FileImporter)new EdigeoPciImporter());
        SessionWriter.registerSessionLayerExporter(WMSLayer.class, CadastreSessionExporter.class);
        SessionReader.registerSessionLayerImporter((String)"cadastre-fr", CadastreSessionImporter.class);
        MainApplication.getMenu().openLocation.addDownloadTaskClass(CadastreDownloadTask.class);
        DownloadDialog.addDownloadSource((DownloadSource)new CadastreDownloadSource());
    }

    private static void initCacheDir() {
        cacheDir = Config.getPref().get("cadastrewms.cacheDir").isEmpty() ? new File(Config.getDirs().getCacheDirectory(true), "cadastrewms").getAbsolutePath() : Config.getPref().get("cadastrewms.cacheDir");
        if (cacheDir.charAt(cacheDir.length() - 1) != File.separatorChar) {
            cacheDir = cacheDir + File.separatorChar;
        }
        Logging.info((String)("current cache directory: " + cacheDir));
    }

    public static void refreshMenu() {
        MainMenu menu = MainApplication.getMenu();
        if (cadastreJMenu == null) {
            cadastreJMenu = menu.addMenu("Cadastre", I18n.tr((String)"Cadastre", (Object[])new Object[0]), 67, menu.getDefaultMenuPos(), HelpUtil.ht((String)"/Plugin/CadastreFr"));
            MenuActionGrab grab = new MenuActionGrab();
            JMenuItem menuGrab = new JMenuItem((Action)((Object)grab));
            KeyStroke ks = grab.getShortcut().getKeyStroke();
            if (ks != null) {
                menuGrab.setAccelerator(ks);
            }
            JMenuItem menuActionGrabPlanImage = new JMenuItem((Action)((Object)new MenuActionGrabPlanImage()));
            JMenuItem menuSettings = new JMenuItem((Action)((Object)new MenuActionNewLocation()));
            JCheckBoxMenuItem menuSource = new JCheckBoxMenuItem(I18n.tr((String)"Auto sourcing", (Object[])new Object[0]));
            menuSource.setSelected(autoSourcing);
            menuSource.addActionListener(ev -> {
                Config.getPref().putBoolean("cadastrewms.autosourcing", menuSource.isSelected());
                autoSourcing = menuSource.isSelected();
            });
            JMenuItem menuLoadFromCache = new JMenuItem((Action)((Object)new MenuActionLoadFromCache()));
            cadastreJMenu.add(menuGrab);
            cadastreJMenu.add(menuActionGrabPlanImage);
            cadastreJMenu.add(menuSettings);
            cadastreJMenu.add(menuSource);
            cadastreJMenu.add(menuLoadFromCache);
            cadastreJMenu.add(new JMenuItem((Action)((Object)new MenuActionOpenPreferences())));
        }
        CadastrePlugin.setEnabledAll(menuEnabled);
    }

    public static void refreshConfiguration() {
        source = CadastrePlugin.checkSourceMillesime();
        autoSourcing = Config.getPref().getBoolean("cadastrewms.autosourcing", true);
        alterColors = Config.getPref().getBoolean("cadastrewms.alterColors");
        drawBoundaries = Config.getPref().getBoolean("cadastrewms.drawBoundaries", false);
        if (alterColors) {
            backgroundTransparent = Config.getPref().getBoolean("cadastrewms.backgroundTransparent");
            transparency = Float.parseFloat(Config.getPref().get("cadastrewms.brightness", "1.0f"));
        } else {
            backgroundTransparent = false;
            transparency = 1.0f;
        }
        String currentResolution = Config.getPref().get("cadastrewms.resolution", "high");
        if ("high".equals(currentResolution)) {
            imageWidth = 1000;
            imageHeight = 800;
        } else if ("medium".equals(currentResolution)) {
            imageWidth = 800;
            imageHeight = 600;
        } else {
            imageWidth = 600;
            imageHeight = 400;
        }
        CadastrePlugin.refreshLayersURL();
        CadastrePlugin.refreshMenu();
    }

    private static void refreshLayersURL() {
        grabLayers = "";
        grabStyles = "";
        int countLayers = 0;
        if (Config.getPref().getBoolean("cadastrewms.layerWater", true)) {
            grabLayers = grabLayers + "CDIF:LS3,";
            grabStyles = grabStyles + "LS3_90,";
            ++countLayers;
        }
        if (Config.getPref().getBoolean("cadastrewms.layerBuilding", true)) {
            grabLayers = grabLayers + "CDIF:BATIMENT,CDIF:LS2,";
            grabStyles = grabStyles + "BATIMENT_90,LS2_90,";
            ++countLayers;
        }
        if (Config.getPref().getBoolean("cadastrewms.layerSymbol", true)) {
            grabLayers = grabLayers + "CDIF:LS1,";
            grabStyles = grabStyles + "LS1_90,";
            ++countLayers;
        }
        if (Config.getPref().getBoolean("cadastrewms.layerParcel", true)) {
            grabLayers = grabLayers + "CDIF:PARCELLE,";
            grabStyles = grabStyles + "PARCELLE_90,";
            ++countLayers;
        }
        if (Config.getPref().getBoolean("cadastrewms.layerNumero", true)) {
            grabLayers = grabLayers + "CDIF:NUMERO,";
            grabStyles = grabStyles + "NUMERO_90,";
            ++countLayers;
        }
        if (Config.getPref().getBoolean("cadastrewms.layerLabel", true)) {
            grabLayers = grabLayers + "CDIF:PT3,CDIF:PT2,CDIF:PT1,";
            grabStyles = grabStyles + "PT3_90,PT2_90,PT1_90,";
            ++countLayers;
        }
        if (Config.getPref().getBoolean("cadastrewms.layerLieudit", true)) {
            grabLayers = grabLayers + "CDIF:LIEUDIT,";
            grabStyles = grabStyles + "LIEUDIT_90,";
            ++countLayers;
        }
        if (Config.getPref().getBoolean("cadastrewms.layerSection", true)) {
            grabLayers = grabLayers + "CDIF:SUBSECTION,CDIF:SECTION,";
            grabStyles = grabStyles + "SUBSECTION_90,SECTION_90,";
            ++countLayers;
        }
        if (Config.getPref().getBoolean("cadastrewms.layerCommune", true)) {
            grabLayers = grabLayers + "CDIF:COMMUNE,";
            grabStyles = grabStyles + "COMMUNE_90,";
            ++countLayers;
        }
        if (countLayers > 2) {
            grabLayers = grabLayers.substring(0, grabLayers.length() - 1);
            grabStyles = grabStyles.substring(0, grabStyles.length() - 1);
        } else {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please enable at least two WMS layers in the cadastre-fr plugin configuration.\nLayers ''Building'' and ''Parcel'' added by default.", (Object[])new Object[0]));
            Config.getPref().putBoolean("cadastrewms.layerBuilding", true);
            Config.getPref().putBoolean("cadastrewms.layerParcel", true);
            grabLayers = grabLayers + "CDIF:BATIMENT,CDIF:LS2,CDIF:PARCELLE";
            grabStyles = grabStyles + "BATIMENT_90,LS2_90,PARCELLE_90";
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new CadastrePreferenceSetting();
    }

    private static void setEnabledAll(boolean isEnabled) {
        for (int i = 0; i < cadastreJMenu.getItemCount(); ++i) {
            JMenuItem item = cadastreJMenu.getItem(i);
            if (item == null || !item.getText().equals(MenuActionGrabPlanImage.NAME)) continue;
            item.setEnabled(isEnabled);
        }
        menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (cadastreJMenu != null) {
            if (oldFrame == null && newFrame != null) {
                CadastrePlugin.setEnabledAll(true);
                MainApplication.getMap().addMapMode(new IconToggleButton((Action)((Object)new WMSAdjustAction())));
                MainApplication.getMap().addMapMode(new IconToggleButton((Action)((Object)new Address())));
            } else if (oldFrame != null && newFrame == null) {
                CadastrePlugin.setEnabledAll(false);
            }
        }
    }

    public static boolean isLambert() {
        String code = ProjectionRegistry.getProjection().toCode();
        return Arrays.asList(ProjectionPreference.lambert.allCodes()).contains(code);
    }

    public static boolean isUtm_france_dom() {
        String code = ProjectionRegistry.getProjection().toCode();
        return Arrays.asList(ProjectionPreference.utm_france_dom.allCodes()).contains(code);
    }

    public static boolean isLambert_cc9() {
        String code = ProjectionRegistry.getProjection().toCode();
        return Arrays.asList(ProjectionPreference.lambert_cc9.allCodes()).contains(code);
    }

    public static boolean isCadastreProjection() {
        return CadastrePlugin.isLambert() || CadastrePlugin.isUtm_france_dom() || CadastrePlugin.isLambert_cc9();
    }

    public static int getCadastreProjectionLayoutZone() {
        Integer code;
        int zone = -1;
        Projection proj = ProjectionRegistry.getProjection();
        if (proj instanceof AbstractProjection && (code = ((AbstractProjection)proj).getEpsgCode()) != null) {
            if (code >= 3942 && code <= 3950) {
                zone = code - 3942;
            } else if (code >= 27561 && 27564 <= code) {
                zone = code - 27561;
            } else {
                HashMap<Integer, Integer> utmfr = new HashMap<Integer, Integer>();
                utmfr.put(2969, 0);
                utmfr.put(2970, 1);
                utmfr.put(2973, 2);
                utmfr.put(2975, 3);
                utmfr.put(2972, 4);
                if (utmfr.containsKey(code)) {
                    zone = (Integer)utmfr.get(code);
                }
            }
        }
        return zone;
    }

    public static void safeSleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Logging.debug((Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void prepareDialog(JDialog dialog) {
        if (Config.getPref().getBoolean("window-handling.option-pane-always-on-top", true)) {
            try {
                dialog.setAlwaysOnTop(true);
            }
            catch (SecurityException e) {
                Logging.warn((String)I18n.tr((String)"Warning: failed to put option pane dialog always on top. Exception was: {0}", (Object[])new Object[]{e.toString()}));
                Logging.trace((Throwable)e);
            }
        }
        dialog.setModal(true);
        dialog.toFront();
        dialog.setDefaultCloseOperation(2);
    }

    public static void addWMSLayer(WMSLayer wmsLayer) {
        if (MainApplication.isDisplayingMapView()) {
            int wmsNewLayerPos = MainApplication.getLayerManager().getLayers().size();
            for (Layer l : MainApplication.getLayerManager().getLayersOfType(WMSLayer.class)) {
                int wmsPos = MainApplication.getLayerManager().getLayers().indexOf(l);
                if (wmsPos >= wmsNewLayerPos) continue;
                wmsNewLayerPos = wmsPos;
            }
            MainApplication.getLayerManager().addLayer((Layer)wmsLayer);
            MainApplication.getMap().mapView.moveLayer((Layer)wmsLayer, wmsNewLayerPos);
        } else {
            MainApplication.getLayerManager().addLayer((Layer)wmsLayer);
        }
    }

    private static String checkSourceMillesime() {
        int currentYear = Calendar.getInstance().get(1);
        Object src = Config.getPref().get("cadastrewms.source", "cadastre-dgi-fr source : Direction G\u00e9n\u00e9rale des Imp\u00f4ts - Cadastre. Mise \u00e0 jour : AAAA");
        String srcYear = ((String)src).substring(((String)src).lastIndexOf(" ") + 1);
        Integer year = null;
        try {
            year = Integer.decode(srcYear);
        }
        catch (NumberFormatException e) {
            Logging.debug((Throwable)e);
        }
        if ("AAAA".equals(srcYear) || year != null && year < currentYear) {
            Logging.info((String)("Replace source year " + srcYear + " by current year " + currentYear));
            src = ((String)src).substring(0, ((String)src).lastIndexOf(" ") + 1) + currentYear;
            Config.getPref().put("cadastrewms.source", (String)src);
        }
        return src;
    }

    public static void askToChangeProjection() {
        GuiHelper.runInEDTAndWait(() -> {
            if (JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"To enable the cadastre WMS plugin, change\nthe current projection to one of the cadastre\nprojections and retry", (Object[])new Object[0]), I18n.tr((String)"Change the current projection", (Object[])new Object[0]), 2) == 0) {
                PreferenceDialog p = new PreferenceDialog((Component)MainApplication.getMainFrame());
                p.selectPreferencesTabByClass(ProjectionPreference.class);
                ((ProjectionPreference)p.getTabbedPane().getSetting(ProjectionPreference.class)).selectProjection(ProjectionPreference.lambert_cc9);
                p.setVisible(true);
            }
        });
    }

    static {
        source = "";
        transparency = 1.0f;
    }
}

