# JOSM Weblate Deployment via Ansible

This project contains a comprehensive Ansible playbook to deploy a production-ready **Weblate** instance on **Ubuntu 24.04**, specifically tuned for the JOSM translation workflow.

## Features

*   **Native Installation:** Uses standard Python `venv`, `pip` and Systemd services.
*   **Production Stack:** Apache (`mod_wsgi`), PostgreSQL (with `pg_trgm`), Redis and a Celery Cluster.
*   **Performance:** Tuned for responsiveness using split Celery workers (isolating heavy VCS operations from the UI), offline compression, and persistent DB connections.
*   **Security:** Prepared for SSL (HSTS, Secure Cookies), process isolation (separate users), and secure file permissions.
*   **JOSM Integration:** Configures a local bare Git repository to bridge Weblate with JOSM's SVN workflow without direct automated commits.

## Prerequisites

* **Control Node:** Linux/macOS/WSL machine with Python 3.
* **Target Node:** Ubuntu 24.04 Server.
  *   *root access required*
  *   *open port 22, 80/443.*

## Quick Start

1.  **Bootstrap the Environment**
    Run the helper script on your control node to set up the local Python environment and generate configuration files:
    ```bash
    ./bootstrap.sh
    ```

2.  **Configure the Instance**
    Edit the generated configuration files in the root and `vars/` folder:
    *   `hosts.ini`: Set your server IP and SSH user.
    *   `vars/main.yml`: General settings (domain, version, DB host).
    *   `vars/secrets.yml`: Passwords and secret keys.

3.  **Run Deployment**
    Activate the environment and run Ansible:
    ```bash
    source .venv/bin/activate
    ansible-playbook -i hosts.ini install_weblate.yml -K
    ```
    *(The `-K` flag prompts for the sudo password of the remote user).*

## Project Structure

*   `install_weblate.yml`: Main Ansible playbook.
*   `templates/`: Jinja2 templates for Apache and Django settings.
*   `vars/main.yml`: Public configuration variables.
*   `vars/secrets.yml`: Sensitive configuration (passwords/keys).
*   `hosts.ini`: Inventory file.

## Maintenance & Upgrades

### How to Upgrade Weblate
1.  Open `vars/main.yml`.
2.  Update the version variable:
    ```yaml
    weblate_version: "5.16.0"
    ```
3.  Re-run the playbook. Ansible will handle dependencies, migrations and static file updates automatically.

### Logs
*   **Web Server:** `/var/log/apache2/weblate_error.log`
*   **Application:** `/var/log/weblate/`
*   **Background Workers:** `/var/log/celery/`
