/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.util.TreeSet;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.buildings_tools.BuildingsToolsPlugin;
import org.openstreetmap.josm.tools.Pair;

public class AngleSnap {
    private static final double PI_2 = 1.5707963267948966;
    final TreeSet<Double> snapSet = new TreeSet();

    public final void clear() {
        this.snapSet.clear();
    }

    public final void addSnap(double snap) {
        this.snapSet.add(snap % 1.5707963267948966);
    }

    public final Double addSnap(Node[] nodes) {
        if (nodes.length == 2) {
            EastNorth p1 = BuildingsToolsPlugin.latlon2eastNorth((ILatLon)nodes[0]);
            EastNorth p2 = BuildingsToolsPlugin.latlon2eastNorth((ILatLon)nodes[1]);
            double heading = p1.heading(p2);
            this.addSnap(heading);
            this.addSnap(heading + 0.7853981633974483);
            return heading;
        }
        return null;
    }

    public final void addSnap(Way way) {
        for (Pair pair : way.getNodePairs(false)) {
            EastNorth a = BuildingsToolsPlugin.latlon2eastNorth((ILatLon)pair.a);
            EastNorth b = BuildingsToolsPlugin.latlon2eastNorth((ILatLon)pair.b);
            double heading = a.heading(b);
            this.addSnap(heading);
        }
    }

    public final Double getAngle() {
        if (this.snapSet.isEmpty()) {
            return null;
        }
        double first = this.snapSet.first();
        double last = this.snapSet.last();
        if (first < 0.7853981633974483 && last > 0.7853981633974483) {
            last -= 1.5707963267948966;
        }
        if (Math.abs(first - last) < 0.001) {
            double center = (first + last) / 2.0;
            if (center < 0.0) {
                center += 1.5707963267948966;
            }
            return center;
        }
        return null;
    }

    public final double snapAngle(double angle) {
        Double next;
        if (this.snapSet.isEmpty()) {
            return angle;
        }
        int quadrant = (int)Math.floor(angle / 1.5707963267948966);
        double ang = angle % 1.5707963267948966;
        Double prev = this.snapSet.floor(ang);
        if (prev == null) {
            prev = this.snapSet.last() - 1.5707963267948966;
        }
        if ((next = this.snapSet.ceiling(ang)) == null) {
            next = this.snapSet.first() + 1.5707963267948966;
        }
        if (Math.abs(ang - next) > Math.abs(ang - prev)) {
            if (Math.abs(ang - prev) > 0.39269908169872414) {
                return angle;
            }
            double ret = prev + 1.5707963267948966 * (double)quadrant;
            if (ret < 0.0) {
                ret += Math.PI * 2;
            }
            return ret;
        }
        if (Math.abs(ang - next) > 0.39269908169872414) {
            return angle;
        }
        double ret = next + 1.5707963267948966 * (double)quadrant;
        if (ret > Math.PI * 2) {
            ret -= Math.PI * 2;
        }
        return ret;
    }
}

