/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import javax.swing.JMenu;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImportImageFileImporter;
import org.openstreetmap.josm.plugins.ImportImagePlugin.LoadImageAction;
import org.openstreetmap.josm.plugins.ImportImagePlugin.PluginOperations;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ImportImagePlugin
extends Plugin {
    JosmAction loadFileAction;
    static Properties pluginProps;
    static final String PLUGIN_DIR;
    static final String PLUGINPROPERTIES_FILENAME = "pluginProperties.properties";
    static final String PLUGINPROPERTIES_PATH;
    static final String PLUGINLIBRARIES_DIR;

    public Properties getPluginProps() {
        return pluginProps;
    }

    public ImportImagePlugin(PluginInformation info) throws IOException {
        super(info);
        try {
            ImportImagePlugin.checkInstallation();
            ImportImagePlugin.loadPluginProps();
            PluginOperations.loadCRSData(pluginProps);
            this.loadFileAction = new LoadImageAction();
            this.loadFileAction.setEnabled(true);
            MainMenu.add((JMenu)MainApplication.getMenu().imagerySubMenu, (JosmAction)this.loadFileAction);
            ExtensionFileFilter.addImporter((FileImporter)new ImportImageFileImporter());
        }
        catch (IOException e) {
            throw new JosmRuntimeException((Throwable)e);
        }
    }

    private static void loadPluginProps() throws IOException {
        if (pluginProps == null || pluginProps.isEmpty()) {
            pluginProps = new Properties();
            try (InputStream stream = Files.newInputStream(Paths.get(PLUGINPROPERTIES_PATH, new String[0]), new OpenOption[0]);){
                pluginProps.load(stream);
            }
            Logging.debug((String)"ImportImagePlugin: Plugin properties loaded");
        }
    }

    private static void writePluginPropsToFileAndLoad() throws IOException {
        if (pluginProps == null || pluginProps.isEmpty()) {
            block13: {
                try (BufferedWriter fw = Files.newBufferedWriter(Paths.get(PLUGINPROPERTIES_PATH, new String[0]), new OpenOption[0]);){
                    URL propertiesURL = ImportImagePlugin.class.getResource("resources/pluginProperties.properties");
                    if (propertiesURL == null) break block13;
                    pluginProps = new Properties();
                    try (InputStream stream = propertiesURL.openStream();){
                        pluginProps.load(stream);
                    }
                    pluginProps.store(fw, null);
                }
            }
            Logging.debug((String)"ImportImagePlugin: Plugin properties loaded");
        }
    }

    private static void checkInstallation() throws IOException {
        boolean isInstalled;
        boolean bl = isInstalled = new File(PLUGINPROPERTIES_PATH).exists() && new File(PLUGIN_DIR).exists() && new File(PLUGINLIBRARIES_DIR).exists();
        if (!isInstalled) {
            File libDir;
            File pluginDir = new File(PLUGIN_DIR);
            if (!pluginDir.exists()) {
                Utils.mkDirs((File)pluginDir);
            }
            if (!(libDir = new File(PLUGINLIBRARIES_DIR)).exists()) {
                Utils.mkDirs((File)libDir);
            }
            ImportImagePlugin.writePluginPropsToFileAndLoad();
            Logging.debug((String)"ImportImagePlugin: Plugin successfully installed");
        }
    }

    static {
        PLUGIN_DIR = Preferences.main().getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/";
        PLUGINPROPERTIES_PATH = PLUGIN_DIR + PLUGINPROPERTIES_FILENAME;
        PLUGINLIBRARIES_DIR = PLUGIN_DIR + "lib/";
    }
}

