/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.matcher;

import java.util.HashMap;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.plugins.conflation.matcher.AccentlessNormalizeRule;
import org.openstreetmap.josm.plugins.conflation.matcher.LetterOrDigitNormalizeRules;
import org.openstreetmap.josm.plugins.conflation.matcher.LowerCaseNormalizeRule;

public class OsmNormalizeRule
implements SimilarNamedWays.NormalizeRule {
    static HashMap<String, SimilarNamedWays.NormalizeRule[]> rulesMap = new HashMap();
    static SimilarNamedWays.NormalizeRule[] defaultRules;
    private final SimilarNamedWays.NormalizeRule[] rules;

    public static SimilarNamedWays.NormalizeRule[] get(String attributeName) {
        if (attributeName.contains("name") || attributeName.equals("addr:street") || attributeName.equals("addr:place")) {
            return rulesMap.get("name");
        }
        return rulesMap.getOrDefault(attributeName, defaultRules);
    }

    public OsmNormalizeRule(String attributeName) {
        this.rules = OsmNormalizeRule.get(attributeName);
    }

    public String normalize(String value) {
        for (SimilarNamedWays.NormalizeRule rule : this.rules) {
            value = rule.normalize(value);
        }
        return value;
    }

    static {
        rulesMap.put("name", new SimilarNamedWays.NormalizeRule[]{AccentlessNormalizeRule.INSTANCE, LowerCaseNormalizeRule.INSTANCE, LetterOrDigitNormalizeRules.INSTANCE});
        rulesMap.put("oneway", new SimilarNamedWays.NormalizeRule[]{LowerCaseNormalizeRule.INSTANCE, new SimilarNamedWays.SynonymRule("yes", new String[]{"true", "1"}), new SimilarNamedWays.SynonymRule("-1", new String[]{"reverse"}), new SimilarNamedWays.SynonymRule("", new String[]{"no", "false", "0"})});
        rulesMap.put("wall", new SimilarNamedWays.NormalizeRule[]{LowerCaseNormalizeRule.INSTANCE, new SimilarNamedWays.SynonymRule("", new String[]{"yes"})});
        defaultRules = new SimilarNamedWays.NormalizeRule[]{AccentlessNormalizeRule.INSTANCE, LowerCaseNormalizeRule.INSTANCE};
    }
}

