/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.matcher;

import com.vividsolutions.jcs.conflate.polygonmatch.FeatureMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.plugins.conflation.matcher.ValueMatcher;

public class AttributeMatcher
implements FeatureMatcher {
    public final String attributeName;
    public final SimilarNamedWays.NormalizeRule[] rules;
    public final ValueMatcher valueMatcher;

    public AttributeMatcher(String name, ValueMatcher valueMatcher, SimilarNamedWays.NormalizeRule ... rules) {
        this.attributeName = name;
        this.valueMatcher = valueMatcher;
        this.rules = rules;
    }

    @Override
    public Matches match(Feature target, FeatureCollection candidates) {
        String targetValue = this.getStringAttribute(target, this.attributeName);
        Matches matches = new Matches(candidates.getFeatureSchema());
        for (Feature candidate : candidates) {
            String candidateValue = this.getStringAttribute(candidate, this.attributeName);
            double score = this.valueMatcher.match(targetValue, candidateValue);
            if (!(score > 0.0)) continue;
            matches.add(candidate, score);
        }
        return matches;
    }

    private String getStringAttribute(Feature feature, String name) {
        String value;
        try {
            value = feature.getString(name);
        }
        catch (IllegalArgumentException e) {
            value = "";
        }
        for (SimilarNamedWays.NormalizeRule r : this.rules) {
            value = r.normalize(value);
        }
        return value;
    }
}

