/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config.parser;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.plugins.conflation.config.parser.IParser;

public class ParsedTextArea
extends JosmTextArea {
    final IParser parser;
    final JMenuItem errorPopupItem = new JMenuItem();
    final JMenuItem infoPopupItem = new JMenuItem();

    public ParsedTextArea(IParser parser) {
        this("", 0, 0, parser);
    }

    public ParsedTextArea(String text, int rows, int columns, IParser parser) {
        super(text, rows, columns);
        this.parser = parser;
        this.setTabSize(4);
        this.setFont(new Font("monospaced", 0, this.getFont().getSize()));
        this.setRows(rows);
        this.setColumns(columns);
        final JPopupMenu errorPopup = new JPopupMenu();
        this.errorPopupItem.setBackground(Color.RED);
        errorPopup.add(this.errorPopupItem);
        this.errorPopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                errorPopup.setVisible(false);
            }
        });
        final JPopupMenu infoPopup = new JPopupMenu();
        infoPopup.add(this.infoPopupItem);
        this.infoPopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                infoPopup.setVisible(false);
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ParsedTextArea.this.updateStatusMessage();
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ParsedTextArea.this.updateStatusMessage();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ParsedTextArea.this.updateStatusMessage();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ParsedTextArea.this.updateStatusMessage();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ParsedTextArea.this.hideStatusMessage();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ParsedTextArea.this.hideStatusMessage();
            }
        });
    }

    public void updateStatusMessage() {
        if (this.isShowing()) {
            this.updateErrorMessage();
            this.updateInfoMessage();
        }
    }

    public void hideStatusMessage() {
        ((JPopupMenu)this.errorPopupItem.getParent()).setVisible(false);
        ((JPopupMenu)this.infoPopupItem.getParent()).setVisible(false);
    }

    void updateErrorMessage() {
        this.parser.parse(this.getText());
        this.updatePopup(this.errorPopupItem, this.parser.getErrorMessage(), this.parser.getLastTokenIndex(), false);
    }

    private void updateInfoMessage() {
        this.parser.parse(this.getText().substring(0, this.getCaretPosition()));
        if (this.parser.isFullyParsed() && !this.parser.isValid()) {
            this.updatePopup(this.infoPopupItem, this.parser.getLastTokenDescription(), this.parser.getLastTokenIndex(), true);
        } else {
            ((JPopupMenu)this.infoPopupItem.getParent()).setVisible(false);
        }
    }

    private static void repackPopupMenuWithoutFlicker(JPopupMenu popupMenu) {
        Window window = SwingUtilities.getWindowAncestor(popupMenu);
        if (window != null) {
            window.pack();
            window.validate();
        } else {
            popupMenu.pack();
            popupMenu.validate();
        }
    }

    private void updatePopup(JMenuItem popupMenuItem, String text, int position, boolean above) {
        JPopupMenu popup = (JPopupMenu)popupMenuItem.getParent();
        if (text != null && !text.isEmpty()) {
            Rectangle positionRect;
            Point textArealocation = this.getLocationOnScreen();
            try {
                positionRect = this.modelToView(position);
            }
            catch (BadLocationException e) {
                positionRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
            }
            popupMenuItem.setText(text);
            ParsedTextArea.repackPopupMenuWithoutFlicker(popup);
            if (above) {
                popup.setLocation(textArealocation.x + positionRect.x, textArealocation.y + positionRect.y - positionRect.height - popup.getHeight());
            } else {
                popup.setLocation(textArealocation.x + positionRect.x, textArealocation.y + positionRect.y + positionRect.height + 10);
            }
            popup.setVisible(true);
        } else {
            popup.setVisible(false);
        }
    }

    protected Document createDefaultModel() {
        return new AutoCompletionDocument();
    }

    class AutoCompletionDocument
    extends PlainDocument {
        AutoCompletionDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (offs < this.getLength()) {
                super.insertString(offs, str, a);
                return;
            }
            String currentText = this.getText(0, this.getLength());
            ParsedTextArea.this.parser.parse(currentText + str);
            List<String> autoCompleteList = ParsedTextArea.this.parser.getCompletionList();
            if (ParsedTextArea.this.parser.isFullyParsed() && autoCompleteList.size() > 0 && (ParsedTextArea.this.parser.getLastTokenIndex() <= this.getLength() || autoCompleteList.size() == 1)) {
                String matchingString = autoCompleteList.get(0);
                if (ParsedTextArea.this.parser.getLastTokenIndex() <= this.getLength()) {
                    this.remove(ParsedTextArea.this.parser.getLastTokenIndex(), currentText.length() - ParsedTextArea.this.parser.getLastTokenIndex());
                    super.insertString(ParsedTextArea.this.parser.getLastTokenIndex(), matchingString, a);
                } else {
                    super.insertString(offs, str, a);
                    super.insertString(ParsedTextArea.this.parser.getLastTokenIndex(), matchingString, a);
                }
                ParsedTextArea.this.setCaretPosition(offs + str.length());
                ParsedTextArea.this.moveCaretPosition(this.getLength());
            } else {
                super.insertString(offs, str, a);
            }
        }
    }
}

