/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config.parser;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.plugins.conflation.config.parser.IParser;
import org.openstreetmap.josm.plugins.conflation.config.parser.InstanceConstructor;

class InstanceParser<M>
implements IParser {
    private final Class<M> mainType;
    private final String mainDescription;
    private String text;
    private int pos;
    private int tokenPos;
    private boolean instantiate;
    private String description;
    private String error;
    private boolean valid;
    private List<String> completionList = new ArrayList<String>();
    final InstanceConstructor[] constructors;
    final HashMap<String, InstanceConstructor> constructorNameMap = new HashMap();
    static final Pattern INTEGER_PATTERN = Pattern.compile("^[+-]?[0-9]+");
    static final Pattern FLOAT_PATTERN = Pattern.compile("^[+-]?[0-9]+(\\.[0-9]*)?([Ee][+-]?[0-9]+)?");
    static final Pattern BOOLEAN_PATTERN = Pattern.compile("^(true)|(false)", 2);
    static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^([a-zA-Z][a-zA-Z0-9_]*)?");
    static final Pattern STRING_PATTERN = Pattern.compile("(\"(?:[^\"\\\\]|\\\\.)*\")|('(?:[^'\\\\]|\\\\.)*')");

    InstanceParser(Class<M> mainType, String mainDescription, InstanceConstructor[] constructors) {
        this.mainType = mainType;
        this.mainDescription = mainDescription;
        this.constructors = constructors;
        for (InstanceConstructor cnstr : constructors) {
            this.constructorNameMap.put(cnstr.name.toLowerCase(), cnstr);
        }
    }

    @Override
    public boolean parse(String text) {
        this.parse(text, false);
        return this.isValid();
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("InstanceParser(" + this.mainType.getSimpleName() + ")\n");
        sb.append("text:    '" + this.text + "'\n");
        sb.append("tokenPos: ");
        for (i = 0; i < this.tokenPos; ++i) {
            sb.append(" ");
        }
        sb.append("|\n");
        sb.append("pos:      ");
        for (i = 0; i < this.pos; ++i) {
            sb.append(" ");
        }
        sb.append("|\n");
        sb.append("length: " + this.text.length() + "\n");
        sb.append("error: " + this.error + "\n");
        sb.append("valid: " + this.valid + "\n");
        sb.append("description: " + this.description + "\n");
        sb.append("completion: " + String.join((CharSequence)", ", this.completionList) + "\n");
        return sb.toString();
    }

    public M parse(String text, boolean instantiate) {
        M result;
        block4: {
            this.text = text;
            this.pos = 0;
            this.tokenPos = 0;
            this.instantiate = instantiate;
            this.description = null;
            this.error = null;
            this.valid = false;
            result = null;
            try {
                result = this.parse(this.mainType, true, this.mainDescription);
                if (this.nextChar() == '\u0000') {
                    this.valid = true;
                } else {
                    this.error = "Unexpected trailing text:" + text.substring(this.pos);
                }
            }
            catch (Throwable t) {
                String string = this.error = t.getMessage() == null ? t.getClass().getSimpleName() : t.getMessage();
                if (!instantiate) break block4;
                throw t;
            }
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isFullyParsed() {
        return this.pos >= this.text.length();
    }

    @Override
    public int getParsedIndex() {
        return this.pos;
    }

    @Override
    public int getLastTokenIndex() {
        return this.tokenPos;
    }

    @Override
    public String getLastTokenDescription() {
        return this.description;
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }

    @Override
    public List<String> getCompletionList() {
        return new ArrayList<String>(this.completionList);
    }

    private <T> T parse(Class<T> type, boolean lastArg, String description) {
        this.completionList.clear();
        if (Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
            return (T)Byte.valueOf(this.findToken(INTEGER_PATTERN, description, "Integer number"));
        }
        if (Short.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
            return (T)Short.valueOf(this.findToken(INTEGER_PATTERN, description, "Integer number"));
        }
        if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            return (T)Integer.valueOf(this.findToken(INTEGER_PATTERN, description, "Integer number"));
        }
        if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
            return (T)Long.valueOf(this.findToken(INTEGER_PATTERN, description, "Integer number"));
        }
        if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return (T)Float.valueOf(this.findToken(FLOAT_PATTERN, description, "Floating-point number"));
        }
        if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return (T)Double.valueOf(this.findToken(FLOAT_PATTERN, description, "Floating-point number"));
        }
        if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            this.completionList.add("true");
            this.completionList.add("false");
            return (T)Boolean.valueOf(this.findToken(BOOLEAN_PATTERN, description, "True or false"));
        }
        if (Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            String s = this.findToken(STRING_PATTERN, description, "Quoted char");
            if ((s = s.replaceAll("\\\\" + s.charAt(0), s.substring(0, 1))).length() != 3) {
                throw new Error("A single character was exepcted");
            }
            return (T)Character.valueOf(s.charAt(1));
        }
        if (String.class.isAssignableFrom(type)) {
            String s = this.findToken(STRING_PATTERN, description, "Quoted string");
            s = s.replaceAll("\\\\" + s.charAt(0), s.substring(0, 1));
            return (T)s.substring(1, s.length() - 1);
        }
        if (type.isPrimitive()) {
            throw new UnsupportedOperationException("Unssuported primitive type " + type);
        }
        if (type.isArray()) {
            if (lastArg && this.nextChar() != '[') {
                Object[] result = this.parseArray(type.getComponentType(), description);
                this.completionList.add(",");
                return (T)result;
            }
            this.expect('[');
            Object[] result = this.parseArray(type.getComponentType(), description);
            this.completionList.add(",");
            this.expect(']');
            return (T)result;
        }
        return this.parseConstructor(type, description);
    }

    private <T> T parseConstructor(Class<T> type, String description) {
        InstanceConstructor cnstr;
        String identifier = this.findToken(IDENTIFIER_PATTERN, description, this.getName(type));
        if (this.isFullyParsed()) {
            for (InstanceConstructor cnstr2 : this.constructorNameMap.values()) {
                if (!cnstr2.name.toLowerCase().startsWith(identifier.toLowerCase()) || !type.isAssignableFrom(cnstr2.type)) continue;
                this.completionList.add(cnstr2.name);
            }
        }
        if ((cnstr = this.constructorNameMap.get(identifier.toLowerCase())) == null) {
            if (identifier.length() > 0) {
                throw new Error("Class not found: " + identifier);
            }
            throw new Error("Missing " + this.getName(type));
        }
        if (!type.isAssignableFrom(cnstr.type)) {
            throw new Error("Class " + identifier + " is not a " + this.getName(type));
        }
        Class<?>[] paramTypes = cnstr.constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        if (paramTypes.length > 0 || this.nextChar() == '(') {
            this.expect('(');
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    this.expect(',');
                }
                params[i] = i == paramTypes.length - 1 && paramTypes[i].isArray() && cnstr.varrgsTypes != null ? this.parseArray(paramTypes[i].getComponentType(), cnstr.varrgsTypes, cnstr.varArgsDescriptions) : this.parse(paramTypes[i], i + 1 == paramTypes.length, cnstr.paramsDescriptipon[i]);
            }
            this.expect(')');
        }
        try {
            if (this.instantiate) {
                return (T)cnstr.constructor.newInstance(params);
            }
            return null;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private Object[] parseArray(Class<?> type, String description) {
        return this.parseArray(type, new Class[]{type}, new String[]{description});
    }

    private Object[] parseArray(Class<?> type, Class<?>[] types, String[] descriptions) {
        ArrayList list = new ArrayList();
        char c = this.nextChar();
        boolean first = true;
        while (first || c != ')' && c != ']' && c != '\u0000') {
            for (int i = 0; i < types.length; ++i) {
                if (!first) {
                    this.expect(',');
                }
                first = false;
                list.add(this.parse(types[i], false, descriptions[i]));
            }
            c = this.nextChar();
        }
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    private void expect(char c) {
        if (this.nextChar() != c) {
            if (this.nextChar() == '\u0000') {
                this.completionList.add("" + c);
            }
            throw new Error("Expecting " + c);
        }
        this.completionList.clear();
        ++this.pos;
    }

    private char nextChar() {
        this.skipSpaces();
        return this.pos < this.text.length() ? this.text.charAt(this.pos) : (char)'\u0000';
    }

    private String findToken(Pattern p, String description, String defaultDescription) {
        this.skipSpaces();
        this.description = description == null || description.isEmpty() ? defaultDescription : description;
        Matcher m = p.matcher(this.text.substring(this.pos));
        if (m.find() && m.start() == 0) {
            this.pos += m.end();
            return m.group();
        }
        throw new Error("Invalid " + defaultDescription);
    }

    private boolean skipSpaces() {
        boolean result = false;
        while (this.pos < this.text.length() && Character.isWhitespace(this.text.charAt(this.pos))) {
            result = true;
            ++this.pos;
        }
        this.tokenPos = this.pos;
        return result;
    }

    private String getName(Class<?> c) {
        for (InstanceConstructor cnstrDscr : this.constructorNameMap.values()) {
            if (cnstrDscr.type != c) continue;
            return cnstrDscr.name;
        }
        return c.getSimpleName();
    }
}

