/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config.parser;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.plugins.conflation.config.parser.InstanceConstructor;
import org.openstreetmap.josm.plugins.conflation.config.parser.InstanceParser;
import org.openstreetmap.josm.plugins.conflation.config.parser.ParsedTextArea;

public class InstanceEditor<T>
extends JPanel {
    HashMap<String, JLabel> classLabelMap = new HashMap();
    HashMap<String, InstanceConstructor> constructorNameMap = new HashMap();
    JTextArea classDescriptionTextArea;
    ParsedTextArea finderExpressionTextArea;
    InstanceParser<T> parser;

    public InstanceEditor(Class<T> mainType, String mainDescription, InstanceConstructor[] constructors, int rows, int cols) {
        this.parser = new InstanceParser<T>(mainType, mainDescription, constructors);
        for (InstanceConstructor cnstr : constructors) {
            this.constructorNameMap.put(cnstr.name.toLowerCase(), cnstr);
        }
        JPanel classListPanel = new JPanel();
        classListPanel.setLayout(new BoxLayout(classListPanel, 1));
        JScrollPane classListPanelScrollPane = new JScrollPane(classListPanel);
        for (final InstanceConstructor cnstrDscr : constructors) {
            JLabel label = new JLabel(cnstrDscr.name);
            this.classLabelMap.put(cnstrDscr.name.toLowerCase(), label);
            label.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    InstanceEditor.this.displayConstructorDescription(cnstrDscr);
                    InstanceEditor.this.selectConstructor(cnstrDscr);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    InstanceEditor.this.displayConstructorDescription(cnstrDscr);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            label.setVisible(false);
            classListPanel.add(label);
        }
        this.classDescriptionTextArea = new JosmTextArea(10, 16);
        this.classDescriptionTextArea.setWrapStyleWord(true);
        this.classDescriptionTextArea.setLineWrap(true);
        this.classDescriptionTextArea.setEditable(false);
        this.classDescriptionTextArea.setBackground(classListPanel.getBackground());
        JScrollPane classDescriptionScrollPane = new JScrollPane(this.classDescriptionTextArea);
        this.finderExpressionTextArea = new ParsedTextArea("", rows, cols, this.parser);
        this.finderExpressionTextArea.setWrapStyleWord(true);
        this.finderExpressionTextArea.setLineWrap(true);
        JScrollPane finderExpressionScrollPane = new JScrollPane((Component)((Object)this.finderExpressionTextArea));
        this.finderExpressionTextArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int position;
                String text = InstanceEditor.this.finderExpressionTextArea.getText();
                String identifier = InstanceEditor.getIdentifierAtPosition(text, position = InstanceEditor.this.finderExpressionTextArea.getCaretPosition()).toLowerCase();
                if (InstanceEditor.this.constructorNameMap.containsKey(identifier)) {
                    InstanceEditor.this.displayConstructorDescription(InstanceEditor.this.constructorNameMap.get(identifier));
                }
                InstanceEditor.this.parser.parse(text.substring(0, InstanceEditor.getBeginingOfIdentifierAtPosition(text, position)));
                if (InstanceEditor.this.parser.isFullyParsed()) {
                    HashSet completionList = new HashSet(InstanceEditor.this.parser.getCompletionList().stream().map(s -> s.toLowerCase()).collect(Collectors.toList()));
                    for (String name : InstanceEditor.this.classLabelMap.keySet()) {
                        InstanceEditor.this.classLabelMap.get(name).setVisible(completionList.contains(name));
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                InstanceEditor.this.finderExpressionTextArea.hideStatusMessage();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                InstanceEditor.this.finderExpressionTextArea.hideStatusMessage();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                InstanceEditor.this.finderExpressionTextArea.hideStatusMessage();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                InstanceEditor.this.finderExpressionTextArea.hideStatusMessage();
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(classListPanelScrollPane).addComponent(classDescriptionScrollPane)).addComponent(finderExpressionScrollPane)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(classListPanelScrollPane).addComponent(classDescriptionScrollPane)).addComponent(finderExpressionScrollPane));
    }

    public T getEditedInstance() {
        return this.parser.parse(this.finderExpressionTextArea.getText(), true);
    }

    public boolean isEditionValid() {
        return this.parser.parse(this.finderExpressionTextArea.getText());
    }

    public JTextArea getTextArea() {
        return this.finderExpressionTextArea;
    }

    private static String getIdentifierAtPosition(String text, int position) {
        int end;
        int start = InstanceEditor.getBeginingOfIdentifierAtPosition(text, position);
        for (end = position; end < text.length() && Character.isJavaIdentifierPart(text.charAt(end)); ++end) {
        }
        return text.substring(start, end);
    }

    private static int getBeginingOfIdentifierAtPosition(String text, int position) {
        while (position > 0 && Character.isJavaIdentifierPart(text.charAt(position - 1))) {
            --position;
        }
        return position;
    }

    private void displayConstructorDescription(InstanceConstructor cnstrDscr) {
        this.classDescriptionTextArea.setText(cnstrDscr.name + "\n\n" + cnstrDscr.description + this.constructorSignature(cnstrDscr));
    }

    private void selectConstructor(InstanceConstructor cnstrDscr) {
        String text = cnstrDscr.name;
        if (cnstrDscr.paramsDescriptipon.length > 0) {
            text = text + "(  )";
        }
        this.finderExpressionTextArea.replaceSelection(text);
        if (cnstrDscr.paramsDescriptipon.length > 0) {
            this.finderExpressionTextArea.setCaretPosition(this.finderExpressionTextArea.getCaretPosition() - 2);
        }
    }

    private String constructorSignature(InstanceConstructor c) {
        StringBuilder sb = new StringBuilder();
        if (c.paramsDescriptipon.length > 0) {
            if (c.paramsDescriptipon.length > 1 || c.varrgsTypes != null) {
                sb.append("\n\nArguments:\n");
            } else {
                sb.append("\n\nArgument:\n");
            }
            for (String argDesc : c.paramsDescriptipon) {
                sb.append(" - " + argDesc + "\n");
            }
        }
        return sb.toString();
    }
}

