/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class InstanceConstructor {
    public final Class<?> type;
    public final String name;
    public final Constructor<?> constructor;
    public final String description;
    public final String[] paramsDescriptipon;
    public final Class<?>[] varrgsTypes;
    public final String[] varArgsDescriptions;

    public InstanceConstructor(Class<?> type, String name, String description, String[] paramsDescriptipon) {
        this(type, name, description, paramsDescriptipon, null, null);
    }

    public InstanceConstructor(Class<?> type, String name, String description, String[] paramsDescriptipon, Class<?>[] varArgsTypes, String[] varArgsDescriptions) {
        this.type = type;
        this.name = name != null ? name : type.getSimpleName();
        this.constructor = this.getLargestPublicConstructor(type);
        this.description = description;
        this.paramsDescriptipon = paramsDescriptipon;
        this.varrgsTypes = varArgsTypes;
        this.varArgsDescriptions = varArgsDescriptions;
        if (this.constructor == null) {
            throw new IllegalArgumentException("No Public constructor found");
        }
        if (this.constructor.getParameterCount() != paramsDescriptipon.length) {
            throw new IllegalArgumentException(type.getSimpleName() + " paramDescription.length is != " + this.constructor.getParameterCount());
        }
        if (varArgsTypes != null) {
            Class<?>[] paramTypes = this.constructor.getParameterTypes();
            assert (paramTypes[paramTypes.length - 1].isArray());
        }
    }

    private Constructor<?> getLargestPublicConstructor(Class<?> type) {
        Constructor<?> bestCnstr = null;
        for (Constructor<?> cnstr : type.getConstructors()) {
            if (!Modifier.isPublic(cnstr.getModifiers()) || bestCnstr != null && cnstr.getParameterTypes().length <= bestCnstr.getParameterTypes().length) continue;
            bestCnstr = cnstr;
        }
        return bestCnstr;
    }
}

