/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config;

import com.vividsolutions.jcs.conflate.polygonmatch.AbstractDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.BasicFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.CentroidDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.ChainMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.DisambiguatingFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.FeatureMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.HausdorffDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.OneToOneFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.WeightedMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.WindowMatcher;
import com.vividsolutions.jcs.plugin.conflate.polygonmatch.MyValidatingTextField;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.conflation.config.DefaultPromptTextField;
import org.openstreetmap.josm.plugins.conflation.config.MatchFinderPanel;
import org.openstreetmap.josm.plugins.conflation.matcher.AttributeMatcher;
import org.openstreetmap.josm.plugins.conflation.matcher.LevenshteinDistanceValueMatcher;
import org.openstreetmap.josm.plugins.conflation.matcher.OsmNormalizeRule;
import org.openstreetmap.josm.plugins.conflation.matcher.StandardDistanceMatcher;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;

public class SimpleMatchFinderPanel
extends MatchFinderPanel {
    private static final double DEFAULT_DISTANCE_THRESHOLD = 30.0;
    private final JLabel methodLabel = new JLabel(I18n.tr((String)"Method", (Object[])new Object[0]));
    private final String[] methodString = new String[]{I18n.tr((String)"Disambiguating", (Object[])new Object[0]), I18n.tr((String)"One to One", (Object[])new Object[0])};
    private final JComboBox<String> methodCombeBox = new JComboBox<String>(this.methodString);
    private final JLabel distanceLabel = new JLabel(I18n.tr((String)"Distance", (Object[])new Object[0]));
    private final String[] distanceStrings = new String[]{I18n.tr((String)"Standard", (Object[])new Object[0]), I18n.tr((String)"Centroid", (Object[])new Object[0]), I18n.tr((String)"Hausdorff", (Object[])new Object[0])};
    private final JComboBox<String> distanceComboBox = new JComboBox<String>(this.distanceStrings);
    private final JLabel threshDistanceLabel = new JLabel(" < ");
    private final MyValidatingTextField threshDistanceField = new MyValidatingTextField("30.0", 4, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private final JLabel tagsLabel = new JLabel(I18n.tr((String)"Tags", (Object[])new Object[0]));
    private final DefaultPromptTextField tagsField = new DefaultPromptTextField(20, I18n.tr((String)"none", (Object[])new Object[0]));

    public SimpleMatchFinderPanel(AutoCompletionList referenceKeysAutocompletionList, IPreferences pref) {
        this.threshDistanceField.setToolTipText(I18n.tr((String)"Maximum Distance", (Object[])new Object[0]));
        this.tagsField.setToolTipText(I18n.tr((String)"List of tags to match (default: none)", (Object[])new Object[0]));
        this.methodCombeBox.setFont(this.methodCombeBox.getFont().deriveFont(0));
        this.distanceComboBox.setFont(this.distanceComboBox.getFont().deriveFont(0));
        this.tagsField.setAutoCompletionList(referenceKeysAutocompletionList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.methodLabel).addComponent(this.distanceLabel).addComponent(this.tagsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.methodCombeBox, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.distanceComboBox, -2, -1, -2).addComponent(this.threshDistanceLabel).addComponent(this.threshDistanceField, -2, -1, -2)).addComponent((Component)((Object)this.tagsField), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 0, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.methodLabel).addComponent(this.methodCombeBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.distanceLabel).addComponent(this.distanceComboBox).addComponent(this.threshDistanceLabel).addComponent(this.threshDistanceField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagsLabel).addComponent((Component)((Object)this.tagsField))));
        this.restoreFromPreferences(pref);
    }

    @Override
    public FCMatchFinder getMatchFinder() {
        AbstractDistanceMatcher distanceMatcher;
        ArrayList<FeatureMatcher> matchers = new ArrayList<FeatureMatcher>();
        if (this.threshDistanceField.getDouble() > 0.0) {
            matchers.add(new WindowMatcher(this.threshDistanceField.getDouble()));
        }
        switch (this.distanceComboBox.getSelectedIndex()) {
            case 1: {
                distanceMatcher = new CentroidDistanceMatcher();
                break;
            }
            case 2: {
                distanceMatcher = new HausdorffDistanceMatcher();
                break;
            }
            default: {
                distanceMatcher = new StandardDistanceMatcher();
            }
        }
        distanceMatcher.setMaxDistance(this.threshDistanceField.getDouble());
        matchers.add(distanceMatcher);
        List<String> tags = SimpleMatchFinderPanel.splitBySpaceComaOrSemicolon(this.tagsField.getText());
        if (tags.size() > 0) {
            ArrayList<Object> weightedArgs = new ArrayList<Object>();
            weightedArgs.add(1.0);
            weightedArgs.add(distanceMatcher);
            for (String tag : tags) {
                weightedArgs.add(1.0);
                weightedArgs.add(new AttributeMatcher(tag, LevenshteinDistanceValueMatcher.INSTANCE, OsmNormalizeRule.get(tag)));
            }
            WeightedMatcher weightedMatcher = new WeightedMatcher(weightedArgs.toArray());
            matchers.add(weightedMatcher);
        }
        ChainMatcher chain = new ChainMatcher(matchers.toArray(new FeatureMatcher[matchers.size()]));
        BasicFCMatchFinder basicFinder = new BasicFCMatchFinder(chain);
        FCMatchFinder finder = this.methodCombeBox.getSelectedIndex() == 0 ? new DisambiguatingFCMatchFinder(basicFinder) : new OneToOneFCMatchFinder(basicFinder);
        return finder;
    }

    public static List<String> splitBySpaceComaOrSemicolon(String values) {
        return Stream.of(values.trim().split("[\\s,;]+")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public void restoreFromPreferences(IPreferences pref) {
        this.methodCombeBox.setSelectedIndex(Integer.max(0, Integer.min(this.methodCombeBox.getItemCount() - 1, pref.getInt(this.getClass().getName() + ".methodIndex", 0))));
        this.distanceComboBox.setSelectedIndex(Integer.max(0, Integer.min(this.distanceComboBox.getItemCount() - 1, pref.getInt(this.getClass().getName() + ".distanceIndex", 1))));
        this.threshDistanceField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".thresholdDistance", 30.0)));
        this.tagsField.setText(pref.get(this.getClass().getName() + ".tags", ""));
    }

    @Override
    public void savePreferences(IPreferences pref) {
        pref.putInt(this.getClass().getName() + ".methodIndex", this.methodCombeBox.getSelectedIndex());
        pref.putInt(this.getClass().getName() + ".distanceIndex", this.distanceComboBox.getSelectedIndex());
        pref.putDouble(this.getClass().getName() + ".thresholdDistance", this.threshDistanceField.getDouble());
        pref.put(this.getClass().getName() + ".tags", this.tagsField.getText());
    }
}

