/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.KeyValueVisitor;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchSettings;
import org.openstreetmap.josm.plugins.conflation.config.MatchingPanel;
import org.openstreetmap.josm.plugins.conflation.config.MergingPanel;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SettingsDialog
extends ExtendedDialog {
    private JButton freezeReferenceButton;
    private JButton freezeSubjectButton;
    private JButton restoreReferenceButton;
    private JButton restoreSubjectButton;
    private JLabel referenceLayerLabel;
    private JLabel subjectLayerLabel;
    private JLabel nbReferenceNodesLabel;
    private JLabel nbReferenceWaysLabel;
    private JLabel nbReferenceRelationsLabel;
    private JLabel nbSubjectNodesLabel;
    private JLabel nbSubjectWaysLabel;
    private JLabel nbSubjectRelationsLabel;
    private AutoCompletionList referenceTagsAutoCompletionList = new AutoCompletionList();
    private MatchingPanel matchingPanel;
    private MergingPanel mergingPanel;
    static final Font italicLabelFont = UIManager.getFont("Label.font").deriveFont(2);
    static final Font plainLabelFont = UIManager.getFont("Label.font").deriveFont(0);
    static final String UNSELECTED_LAYER_NAME = I18n.tr((String)"<Please select data>", (Object[])new Object[0]);
    List<OsmPrimitive> subjectSelection = null;
    List<OsmPrimitive> referenceSelection = null;
    OsmDataLayer referenceLayer;
    DataSet subjectDataSet;
    OsmDataLayer subjectLayer;
    DataSet referenceDataSet;

    public SettingsDialog(IPreferences pref) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Configure conflation settings", (Object[])new Object[0]), new String[]{I18n.tr((String)"Generate matches", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, false);
        this.setButtonIcons(new Icon[]{ImageProvider.get((String)"ok"), ImageProvider.get((String)"cancel")});
        this.referenceSelection = new ArrayList<OsmPrimitive>();
        this.subjectSelection = new ArrayList<OsmPrimitive>();
        this.initComponents(pref);
        this.restoreFromPreferences(pref);
        this.initListeners();
        this.update();
    }

    private void initComponents(IPreferences pref) {
        this.matchingPanel = new MatchingPanel(this.referenceTagsAutoCompletionList, pref, () -> this.pack());
        this.matchingPanel.setBorder(this.createLightTitleBorder(I18n.tr((String)"Matching", (Object[])new Object[0])));
        this.mergingPanel = new MergingPanel(this.referenceTagsAutoCompletionList, pref);
        this.mergingPanel.setBorder(this.createLightTitleBorder(I18n.tr((String)"Merging", (Object[])new Object[0])));
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 3));
        pnl.setAlignmentX(0.0f);
        pnl.add(this.createDataLayersPanel());
        pnl.add(this.matchingPanel);
        pnl.add(this.mergingPanel);
        this.setContent(pnl);
        this.setupDialog();
    }

    private void initListeners() {
        final DataSelectionListener selectionChangeListener = event -> this.updateFreezeButtons(!event.getSelection().isEmpty());
        final MainLayerManager.ActiveLayerChangeListener layerChangeListener = new MainLayerManager.ActiveLayerChangeListener(){

            public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
                SettingsDialog.this.updateFreezeButtons();
            }
        };
        this.addComponentListener(new ComponentAdapter(){
            private boolean listenersAdded = false;

            @Override
            public void componentHidden(ComponentEvent e) {
                if (this.listenersAdded) {
                    SelectionEventManager.getInstance().removeSelectionListener(selectionChangeListener);
                    MainApplication.getLayerManager().removeActiveLayerChangeListener(layerChangeListener);
                    this.listenersAdded = false;
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (!this.listenersAdded) {
                    SelectionEventManager.getInstance().addSelectionListener(selectionChangeListener);
                    MainApplication.getLayerManager().addActiveLayerChangeListener(layerChangeListener);
                    this.listenersAdded = true;
                }
                SettingsDialog.this.updateFreezeButtons();
            }
        });
    }

    public JPanel createDataLayersPanel() {
        JPanel panel = new JPanel();
        JLabel referenceLabel = new JLabel(I18n.tr((String)"Reference:", (Object[])new Object[0]));
        JLabel subjectLabel = new JLabel(I18n.tr((String)"Subject:", (Object[])new Object[0]));
        JLabel layerLabel = new JLabel(I18n.tr((String)"Layer", (Object[])new Object[0]));
        JLabel waysLabel = new JLabel("W");
        JLabel relationsLabel = new JLabel("R");
        JLabel nodesLabel = new JLabel("N");
        this.restoreReferenceButton = new JButton((Action)((Object)new RestoreReferenceAction()));
        this.freezeReferenceButton = new JButton((Action)((Object)new FreezeReferenceAction()));
        this.restoreSubjectButton = new JButton((Action)((Object)new RestoreSubjectAction()));
        this.freezeSubjectButton = new JButton((Action)((Object)new FreezeSubjectAction()));
        this.nbReferenceNodesLabel = new JLabel("0");
        this.nbReferenceWaysLabel = new JLabel("0");
        this.nbReferenceRelationsLabel = new JLabel("0");
        this.nbSubjectNodesLabel = new JLabel("0");
        this.nbSubjectWaysLabel = new JLabel("0");
        this.nbSubjectRelationsLabel = new JLabel("0");
        this.referenceLayerLabel = new JLabel();
        this.subjectLayerLabel = new JLabel();
        this.referenceLayerLabel.setOpaque(true);
        this.subjectLayerLabel.setOpaque(true);
        JLabel empty1 = new JLabel();
        JLabel empty2 = new JLabel();
        JLabel empty3 = new JLabel();
        nodesLabel.setFont(italicLabelFont);
        waysLabel.setFont(italicLabelFont);
        relationsLabel.setFont(italicLabelFont);
        this.nbReferenceNodesLabel.setFont(italicLabelFont);
        this.nbReferenceWaysLabel.setFont(italicLabelFont);
        this.nbReferenceRelationsLabel.setFont(italicLabelFont);
        this.nbSubjectNodesLabel.setFont(italicLabelFont);
        this.nbSubjectWaysLabel.setFont(italicLabelFont);
        this.nbSubjectRelationsLabel.setFont(italicLabelFont);
        layerLabel.setBorder(new MatteBorder(0, 0, 2, 0, Color.DARK_GRAY));
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(empty1).addComponent(referenceLabel).addComponent(subjectLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(empty2).addComponent(this.freezeReferenceButton).addComponent(this.freezeSubjectButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(empty3).addComponent(this.restoreReferenceButton).addComponent(this.restoreSubjectButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(layerLabel).addComponent(this.referenceLayerLabel, 200, -1, -1).addComponent(this.subjectLayerLabel, 200, -1, -1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(nodesLabel).addComponent(this.nbReferenceNodesLabel).addComponent(this.nbSubjectNodesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(waysLabel).addComponent(this.nbReferenceWaysLabel).addComponent(this.nbSubjectWaysLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(relationsLabel).addComponent(this.nbReferenceRelationsLabel).addComponent(this.nbSubjectRelationsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(empty1).addComponent(empty2).addComponent(empty3).addComponent(layerLabel).addComponent(nodesLabel).addComponent(waysLabel).addComponent(relationsLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(referenceLabel).addComponent(this.freezeReferenceButton).addComponent(this.restoreReferenceButton).addComponent(this.referenceLayerLabel).addComponent(this.nbReferenceNodesLabel).addComponent(this.nbReferenceWaysLabel).addComponent(this.nbReferenceRelationsLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(subjectLabel).addComponent(this.freezeSubjectButton).addComponent(this.restoreSubjectButton).addComponent(this.subjectLayerLabel).addComponent(this.nbSubjectNodesLabel).addComponent(this.nbSubjectWaysLabel).addComponent(this.nbSubjectRelationsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10));
        return panel;
    }

    private Border createLightTitleBorder(String title) {
        TitledBorder tileBorder = BorderFactory.createTitledBorder(title);
        tileBorder.setTitleFont(italicLabelFont);
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        return new CompoundBorder(tileBorder, emptyBorder);
    }

    public boolean checkValidityOrNotifyProblems() {
        if (this.referenceSelection.isEmpty() || this.subjectSelection.isEmpty()) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Selections must be made for both reference and subject.", (Object[])new Object[0]), I18n.tr((String)"Incomplete selections", (Object[])new Object[0]), 0);
            return false;
        }
        return true;
    }

    public SimpleMatchSettings getSettings() {
        SimpleMatchSettings settings = new SimpleMatchSettings();
        settings.referenceDataSet = this.referenceDataSet;
        settings.referenceLayer = this.referenceLayer;
        settings.referenceSelection = this.referenceSelection;
        settings.subjectDataSet = this.subjectDataSet;
        settings.subjectLayer = this.subjectLayer;
        settings.subjectSelection = this.subjectSelection;
        this.matchingPanel.fillSettings(settings);
        this.mergingPanel.fillSettings(settings);
        return settings;
    }

    public void savePreferences(IPreferences pref) {
        this.matchingPanel.savePreferences(pref);
        this.mergingPanel.savePreferences(pref);
    }

    public void restoreFromPreferences(IPreferences pref) {
        this.matchingPanel.restoreFromPreferences(pref);
        this.mergingPanel.restoreFromPreferences(pref);
    }

    void update() {
        int numNodes = 0;
        int numWays = 0;
        int numRelations = 0;
        int totalRelations = 0;
        if (this.subjectLayer != null && this.subjectLayer == this.referenceLayer && !this.subjectSelection.isEmpty()) {
            boolean identicalSet;
            boolean bl = identicalSet = this.subjectSelection.size() == this.referenceSelection.size() && new HashSet<OsmPrimitive>(this.subjectSelection).containsAll(this.referenceSelection);
            if (identicalSet) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Reference and subject sets should better be different.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            }
        }
        if (!this.subjectSelection.isEmpty()) {
            for (OsmPrimitive p : this.subjectSelection) {
                if (p instanceof Node) {
                    ++numNodes;
                    continue;
                }
                if (p instanceof Way) {
                    ++numWays;
                    continue;
                }
                if (!(p instanceof Relation)) continue;
                ++numRelations;
            }
            this.subjectLayerLabel.setText(this.subjectLayer.getName());
            this.subjectLayerLabel.setOpaque(false);
            this.nbSubjectNodesLabel.setText("" + numNodes);
            this.nbSubjectWaysLabel.setText("" + numWays);
            this.nbSubjectRelationsLabel.setText("" + numRelations);
            this.restoreSubjectButton.setEnabled(true);
        } else {
            this.subjectLayerLabel.setText(UNSELECTED_LAYER_NAME);
            this.subjectLayerLabel.setBackground(Color.YELLOW);
            this.subjectLayerLabel.setOpaque(true);
            this.nbSubjectNodesLabel.setText("0");
            this.nbSubjectWaysLabel.setText("0");
            this.nbSubjectRelationsLabel.setText("0");
            this.restoreSubjectButton.setEnabled(false);
        }
        totalRelations += numRelations;
        numNodes = 0;
        numWays = 0;
        numRelations = 0;
        if (!this.referenceSelection.isEmpty()) {
            HashSet referenceKeys = new HashSet();
            KeyValueVisitor referenceKeysVisitor = (primitive, key, value) -> referenceKeys.add(key);
            for (OsmPrimitive p : this.referenceSelection) {
                if (p instanceof Node) {
                    ++numNodes;
                } else if (p instanceof Way) {
                    ++numWays;
                } else if (p instanceof Relation) {
                    ++numRelations;
                }
                p.visitKeys(referenceKeysVisitor);
            }
            referenceKeys.removeAll(OsmPrimitive.getDiscardableKeys());
            this.referenceTagsAutoCompletionList.clear();
            this.referenceTagsAutoCompletionList.add(referenceKeys, AutoCompletionPriority.IS_IN_DATASET);
            this.referenceLayerLabel.setText(this.referenceLayer.getName());
            this.referenceLayerLabel.setOpaque(false);
            this.nbReferenceNodesLabel.setText("" + numNodes);
            this.nbReferenceWaysLabel.setText("" + numWays);
            this.nbReferenceRelationsLabel.setText("" + numRelations);
            this.restoreReferenceButton.setEnabled(true);
        } else {
            this.referenceTagsAutoCompletionList.clear();
            this.referenceLayerLabel.setText(UNSELECTED_LAYER_NAME);
            this.referenceLayerLabel.setBackground(Color.YELLOW);
            this.referenceLayerLabel.setOpaque(true);
            this.nbReferenceNodesLabel.setText("0");
            this.nbReferenceWaysLabel.setText("0");
            this.nbReferenceRelationsLabel.setText("0");
            this.restoreReferenceButton.setEnabled(false);
        }
        if ((totalRelations += numRelations) != 0) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Relations are not supported yet, please do not select them.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
        this.updateFreezeButtons();
        this.pack();
    }

    public void updateFreezeButtons() {
        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
        this.updateFreezeButtons(dataSet == null ? false : !dataSet.getSelected().isEmpty());
    }

    public void updateFreezeButtons(boolean enabled) {
        this.freezeReferenceButton.setEnabled(enabled);
        this.freezeSubjectButton.setEnabled(enabled);
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        Layer removedLayer = e.getRemovedLayer();
        this.clear(removedLayer == this.referenceLayer, removedLayer == this.subjectLayer);
    }

    public void clear(boolean shouldClearReference, boolean shouldClearSubject) {
        if (shouldClearReference || shouldClearSubject) {
            if (shouldClearReference) {
                this.referenceLayer = null;
                this.referenceDataSet = null;
                this.referenceSelection.clear();
            }
            if (shouldClearSubject) {
                this.subjectLayer = null;
                this.subjectDataSet = null;
                this.subjectSelection.clear();
            }
            this.update();
        }
    }

    class FreezeReferenceAction
    extends JosmAction {
        FreezeReferenceAction() {
            super(I18n.tr((String)"Freeze", (Object[])new Object[0]), null, I18n.tr((String)"Freeze reference selection", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.referenceDataSet = MainApplication.getLayerManager().getEditDataSet();
            SettingsDialog.this.referenceLayer = MainApplication.getLayerManager().getEditLayer();
            if (SettingsDialog.this.referenceDataSet == null || SettingsDialog.this.referenceLayer == null) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"No valid OSM data layer present.", (Object[])new Object[0]), I18n.tr((String)"Error freezing selection", (Object[])new Object[0]), 0);
                return;
            }
            SettingsDialog.this.referenceSelection.clear();
            SettingsDialog.this.referenceSelection.addAll(SettingsDialog.this.referenceDataSet.getSelected());
            if (SettingsDialog.this.referenceSelection.isEmpty()) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Nothing is selected, please try again.", (Object[])new Object[0]), I18n.tr((String)"Empty selection", (Object[])new Object[0]), 0);
                return;
            }
            SettingsDialog.this.update();
        }
    }

    class FreezeSubjectAction
    extends JosmAction {
        FreezeSubjectAction() {
            super(I18n.tr((String)"Freeze", (Object[])new Object[0]), null, I18n.tr((String)"Freeze subject selection", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.subjectDataSet = MainApplication.getLayerManager().getEditDataSet();
            SettingsDialog.this.subjectLayer = MainApplication.getLayerManager().getEditLayer();
            if (SettingsDialog.this.subjectDataSet == null || SettingsDialog.this.subjectLayer == null) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"No valid OSM data layer present.", (Object[])new Object[0]), I18n.tr((String)"Error freezing selection", (Object[])new Object[0]), 0);
                return;
            }
            SettingsDialog.this.subjectSelection.clear();
            SettingsDialog.this.subjectSelection.addAll(SettingsDialog.this.subjectDataSet.getSelected());
            if (SettingsDialog.this.subjectSelection.isEmpty()) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Nothing is selected, please try again.", (Object[])new Object[0]), I18n.tr((String)"Empty selection", (Object[])new Object[0]), 0);
                return;
            }
            SettingsDialog.this.update();
        }
    }

    class RestoreReferenceAction
    extends JosmAction {
        RestoreReferenceAction() {
            super(I18n.tr((String)"Restore", (Object[])new Object[0]), null, I18n.tr((String)"Restore reference selection", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (SettingsDialog.this.referenceLayer != null && SettingsDialog.this.referenceDataSet != null && SettingsDialog.this.referenceSelection != null && !SettingsDialog.this.referenceSelection.isEmpty()) {
                MainApplication.getLayerManager().setActiveLayer((Layer)SettingsDialog.this.referenceLayer);
                SettingsDialog.this.referenceLayer.setVisible(true);
                SettingsDialog.this.referenceDataSet.setSelected(SettingsDialog.this.referenceSelection);
            }
        }
    }

    class RestoreSubjectAction
    extends JosmAction {
        RestoreSubjectAction() {
            super(I18n.tr((String)"Restore", (Object[])new Object[0]), null, I18n.tr((String)"Restore subject selection", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (SettingsDialog.this.subjectLayer != null && SettingsDialog.this.subjectDataSet != null && SettingsDialog.this.subjectSelection != null && !SettingsDialog.this.subjectSelection.isEmpty()) {
                MainApplication.getLayerManager().setActiveLayer((Layer)SettingsDialog.this.subjectLayer);
                SettingsDialog.this.subjectLayer.setVisible(true);
                SettingsDialog.this.subjectDataSet.setSelected(SettingsDialog.this.subjectSelection);
            }
        }
    }
}

