/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config;

import com.vividsolutions.jcs.conflate.polygonmatch.AngleHistogramMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.AreaFilterFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.BasicFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.CentroidAligner;
import com.vividsolutions.jcs.conflate.polygonmatch.CentroidDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.ChainMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.CombinatorialFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.CompactnessMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.DisambiguatingFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.FeatureMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.HausdorffDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.IdenticalFeatureFilter;
import com.vividsolutions.jcs.conflate.polygonmatch.MinScoreMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.OneToOneFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.OverlapMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.ScaleScoresMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.ScoreStretcher;
import com.vividsolutions.jcs.conflate.polygonmatch.SymDiffMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.TargetUnioningFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.TopMatchDisambiguatingFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.TopScoreMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.WeightedMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.WindowMatcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.plugins.conflation.config.MatchFinderPanel;
import org.openstreetmap.josm.plugins.conflation.config.parser.InstanceConstructor;
import org.openstreetmap.josm.plugins.conflation.config.parser.InstanceEditor;
import org.openstreetmap.josm.plugins.conflation.matcher.AccentlessNormalizeRule;
import org.openstreetmap.josm.plugins.conflation.matcher.AttributeMatcher;
import org.openstreetmap.josm.plugins.conflation.matcher.ExactValueMatcher;
import org.openstreetmap.josm.plugins.conflation.matcher.LetterOrDigitNormalizeRules;
import org.openstreetmap.josm.plugins.conflation.matcher.LevenshteinDistanceValueMatcher;
import org.openstreetmap.josm.plugins.conflation.matcher.LowerCaseNormalizeRule;
import org.openstreetmap.josm.plugins.conflation.matcher.NoneNormalizeRule;
import org.openstreetmap.josm.plugins.conflation.matcher.OsmNormalizeRule;
import org.openstreetmap.josm.plugins.conflation.matcher.StandardDistanceMatcher;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;

public final class ProgrammingMatchFinderPanel
extends MatchFinderPanel {
    private final InstanceEditor<FCMatchFinder> editorPanel;
    private static final String SIMPLE_EXAMPLE = "Disambiguating(\n\tBasic(\n\t\tChain(\n\t\t\tWindow( 20 ),\n\t\t\tHausdorffDistance( 20 )\n)))\n";
    private static final String ADVANCED_EXAMPLE = "AreaFilter ( 0.0, 9E6, \n\tTargetUnioning( 2,\n\t\tDisambiguating(\n\t\t\tBasic(\n\t\t\t\tChain(\n\t\t\t\t\tWindow( 50 ),\n\t\t\t\t\tStandardDistance( 50 ),\n\t\t\t\t\tCentroidDistance( 50 ),\n\t\t\t\t\tAttribute( 'exact_tag', Exact, NONE ),\n\t\t\t\t\tWeighted(\n\t\t\t\t\t\t10, StandardDistance( 50 ),\n\t\t\t\t\t\t10, CentroidDistance( 50 ),\n\t\t\t\t\t\t10, CentroidAligner( HausdorffDistance( 0 ) ),\n\t\t\t\t\t\t10, SymDiff,\n\t\t\t\t\t\t10, CentroidAligner( SymDiff ),\n\t\t\t\t\t\t10, Compactness,\n\t\t\t\t\t\t10, AngleHistogram( 18 ),\n\t\t\t\t\t\t50, Attribute( 'name', LevenshteinDistance( 0 ), OsmRule( 'name' ))\n\t\t\t\t\t),\n\t\t\t\t\tIdenticalFilter\n)))))";
    public static final InstanceConstructor[] jcsConstructors = new InstanceConstructor[]{new InstanceConstructor(AngleHistogramMatcher.class, "AngleHistogram", "Matches geometries by comparing their 'angle histograms'. An angle histogram is a histogram of segment angles (with the positive x-axis), weighted by segment length. Angles range from -pi to +pi.", new String[]{"the number of bins into which the angles (-pi to +pi) should be split"}), new InstanceConstructor(AreaFilterFCMatchFinder.class, "AreaFilter", "Speeds up processing by ignoring target and candidate features with areas greater than a specified maximum or less than a specified minimum.", new String[]{"mininimum area", "maximum area", "match finder"}), new InstanceConstructor(AttributeMatcher.class, "Attribute", "Match a specific attribute", new String[]{"the attribute name", "how to compute score", "normalize values"}), new InstanceConstructor(BasicFCMatchFinder.class, "Basic", "Applies a FeatureMatcher to each item", new String[]{"matcher"}), new InstanceConstructor(CentroidAligner.class, "CentroidAligner", "Centroid Aligner", new String[]{"matcher"}), new InstanceConstructor(CentroidDistanceMatcher.class, "CentroidDistance", "Centroid Distance", new String[]{"maximum distance, if 0 then score will be relative to the combined envelope diagonale."}), new InstanceConstructor(ChainMatcher.class, "Chain", "Composes several FeatureMatchers into one. Candidate features are whittled down by applying each FeatureMatcher.\n\nNote: Only the last FeatureMatcher's scores are preserved; the other scores are lost. However, this behaviour should be acceptable for most situations Typically you use the Chained Matcher to do some initial filtering before the 'real' matching. The scores from this initial filtering are usually ignored (they're usually just 1 or 0, as in the case of WindowFilter).", new String[]{"matchers"}), new InstanceConstructor(CombinatorialFCMatchFinder.class, "Combinatorial", "An FCMatchFinder wrapper that also treats pairs of adjacent target features as themselves target features. Such pairs are formed into composite target features. These composites are temporary -- before the results are returned, each composite is split into its constituent features. <P>\n\nThe result returned is a one-to-one mapping of target feature to matched candidate feature; the one-to-one mapping is achieved by discarding all matches except for those with the highest scores, for each feature (target and matched candidate). <P>\n\nNote on composites: if a composite's top score is higher than the top score of each of its constituents, the composite match is retained and constituent matches are discarded; otherwise, the composite match is discarded and constituent matches are retained.", new String[]{"maximum composite size", "match finder"}), new InstanceConstructor(CompactnessMatcher.class, "Compactness", "Uses (4 x pi x Area) / (Perimeter^2) as a shape characteristic. The maximum value is 1 (for circles).", new String[0]), new InstanceConstructor(DisambiguatingFCMatchFinder.class, "Disambiguating", "Enforces a one-to-one relationship between target features and matched candidate features, in the returned result set.\n'Aggressive' because 2nd, 3rd, 4th, etc. best matches are tried if the 1st, 2nd, 3rd, etc. match is 'taken' by another feature.", new String[]{"match finder"}), new InstanceConstructor(HausdorffDistanceMatcher.class, "HausdorffDistance", "Hausdorff Distance", new String[]{"maximum distance, if 0 then score will be relative to the combined envelope diagonale."}), new InstanceConstructor(IdenticalFeatureFilter.class, "IdenticalFilter", "Filters out matches where features are identical.", new String[0]), new InstanceConstructor(StandardDistanceMatcher.class, "StandardDistance", "Standard Distance (i.e. the minimum) between the two geometries.", new String[]{"maximum distance, if 0 then score will be relative to the combined envelope diagonale."}), new InstanceConstructor(MinScoreMatcher.class, "MinScore", "Filters out shapes with a score below a given value.", new String[]{"minimun score"}), new InstanceConstructor(OneToOneFCMatchFinder.class, "OneToOne", "Enforces a one-to-one relationship between target features and matched candidate features, in the returned result set. The one-to-one constraint is achieved by discarding all matches except the top match, for each feature (target and candidate).\n\nExample: 'OneToOne' wraps a FCMatchFinder that returns the following matches (and scores):\nT1-C1 (0.8), T2-C1 (0.9), T2-C2 (0.8), T2-C3 (1.0), T3-C4 (0.5).\nT1 and T2 are from the target dataset, whereas C1, C2, and C3 are from the candidate dataset. 'OneToOne' filters out all matches except the top ones, for each feature, leaving:\nT2-C3 (1.0), T3-C4 (0.5).", new String[]{"match finder"}), new InstanceConstructor(OverlapMatcher.class, "Overlap", "", new String[0]), new InstanceConstructor(ScaleScoresMatcher.class, "ScaleScores", "Re-scales the scores output from another FeatureMatcher", new String[]{"newZeroScore: the score that will be warped to 0", "newFullScore the score that will be warped to 1"}), new InstanceConstructor(ScoreStretcher.class, "ScoreStretcher", "Re-scales the scores output from another FeatureMatcher", new String[]{"minimum score, that will be warped to 0", "maximum ccore, that will be warped to 1"}), new InstanceConstructor(SymDiffMatcher.class, "SymDiff", "Uses symmetric difference as the criterion for determining match scores.", new String[0]), new InstanceConstructor(TargetUnioningFCMatchFinder.class, "TargetUnioning", "An FCMatchFinder wrapper that also treats unions of adjacent target features as themselves target features. Such unions are formed into composite target features. These composites are temporary -- before the results are returned, each composite is split into its constituent features.\n\nThe result returned is a one-to-one mapping of target feature to matched candidate feature; the one-to-one mapping is achieved by discarding all matches except for those with the highest scores, for each feature (target and matched candidate).\n\nNote on composites: if a composite's top score is higher than the top score of each of its constituents, the composite match is retained and constituent matches are discarded; otherwise, the composite match is discarded and constituent matches are retained.", new String[]{"maximum number of adjacent target features to try combining", "match finder"}), new InstanceConstructor(TopMatchDisambiguatingFCMatchFinder.class, "TopMatchDisambiguating", "Enforces a one-to-one relationship between target features and matched candidate features, in the returned result set. 'Conservative' because only top matches are allowed. \n\nNote: 'Disambiguating' finder seems to give better results.\n\nExample: 'OneToOne' finder wraps a FCMatchFinder that returns the following matches (and scores):\nT1-C1 (0.8), T2-C1 (0.9), T2-C2 (0.8), T2-C3 (1.0), T3-C4 (0.5).\nT1 and T2 are from the target dataset, whereas C1, C2, and C3 are from the candidate dataset. 'OneToOne' filters out all matches except the top ones, for each feature, leaving:\nT2-C3 (1.0), T3-C4 (0.5).", new String[]{"match finder"}), new InstanceConstructor(TopScoreMatcher.class, "TopScore", "Filters out all shapes except the one with the top score.", new String[0]), new InstanceConstructor(WeightedMatcher.class, "Weighted", "Runs multiple FeatureMatchers, and combines their scores using a weighted average.\n\nTake as argument matchers and weights: alternates between FeatureMatchers and floating point numbers.", new String[]{"weights and matchers: alternates between Doubles and FeatureMatchers"}, new Class[]{Double.class, FeatureMatcher.class}, new String[]{"the weight given to scores returned by the matcher", "a matcher to add"}), new InstanceConstructor(WindowMatcher.class, "Window", "Quickly filters out shapes that lie outside a given distance from the feature's envelope.", new String[]{"buffer: for each feature, the window will be the envelope extended on each side by this amount"}), new InstanceConstructor(ExactValueMatcher.class, "Exact", "Match only value exactly identical", new String[0]), new InstanceConstructor(LevenshteinDistanceValueMatcher.class, "LevenshteinDistance", "Score according to the Levenshtein distance\n\nIf the given parameter is 0 then the score will be relative to the string length.", new String[]{"max number of character modifications, defaut value 0 means max is the string length"}), new InstanceConstructor(NoneNormalizeRule.class, "None", "No normalization", new String[0]), new InstanceConstructor(AccentlessNormalizeRule.class, "Accentless", "Remove accent", new String[0]), new InstanceConstructor(LetterOrDigitNormalizeRules.class, "LetterOrDigit", "Keep only letters or digits characters (remove spaces, punctuation,...)\n\nREM: there will be no more word separations", new String[0]), new InstanceConstructor(LowerCaseNormalizeRule.class, "LowerCase", "Normalize to lower case", new String[0]), new InstanceConstructor(SimilarNamedWays.RegExprRule.class, "RegExpr", "Apply regular expression substitution", new String[]{"regular expression", "replacement"}), new InstanceConstructor(SimilarNamedWays.SynonymRule.class, "Synonym", "Substitute synonyms by a common word", new String[]{"replacement", "synomym words"}), new InstanceConstructor(OsmNormalizeRule.class, "OsmRule", "Arbitrary normalization to be improoved....\n\nIf the tags name contains the word 'name', is 'addr:street' or 'addr:place',then the following normalization list is applied:\n - Accentless, LowerCase, LetterOrDigit", new String[]{"tag name (need to be specified again"})};

    public ProgrammingMatchFinderPanel(IPreferences pref) {
        this.setLayout(new BoxLayout(this, 1));
        this.editorPanel = new InstanceEditor<FCMatchFinder>(FCMatchFinder.class, "Match Finder", jcsConstructors, 8, 70);
        this.add(this.editorPanel);
        this.add(this.createExampleButtonPanel());
        this.restoreFromPreferences(pref);
    }

    private JPanel createExampleButtonPanel() {
        JPanel buttonsPanel = new JPanel();
        JButton simpleButton = new JButton(I18n.tr((String)"Simple Example", (Object[])new Object[0]));
        JButton advancedButton = new JButton(I18n.tr((String)"Advanced Example", (Object[])new Object[0]));
        buttonsPanel.add(simpleButton);
        buttonsPanel.add(advancedButton);
        simpleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgrammingMatchFinderPanel.this.editorPanel.getTextArea().replaceRange(ProgrammingMatchFinderPanel.SIMPLE_EXAMPLE, 0, ProgrammingMatchFinderPanel.this.editorPanel.getTextArea().getText().length());
            }
        });
        advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgrammingMatchFinderPanel.this.editorPanel.getTextArea().replaceRange(ProgrammingMatchFinderPanel.ADVANCED_EXAMPLE, 0, ProgrammingMatchFinderPanel.this.editorPanel.getTextArea().getText().length());
            }
        });
        return buttonsPanel;
    }

    @Override
    public FCMatchFinder getMatchFinder() {
        return this.editorPanel.getEditedInstance();
    }

    public void restoreFromPreferences(IPreferences pref) {
        this.editorPanel.getTextArea().setText(pref.get(this.getClass().getName() + ".expression", SIMPLE_EXAMPLE));
    }

    @Override
    public void savePreferences(IPreferences pref) {
        pref.put(this.getClass().getName() + ".expression", this.editorPanel.getTextArea().getText());
    }
}

