/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchSettings;
import org.openstreetmap.josm.plugins.conflation.config.DefaultPromptTextField;
import org.openstreetmap.josm.plugins.conflation.config.SimpleMatchFinderPanel;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;

public class MergingPanel
extends JPanel {
    private JCheckBox replaceGeometryCheckBox;
    private JCheckBox mergeTagsCheckBox;
    private JCheckBox mergeAllCheckBox;
    private DefaultPromptTextField mergeTagsField;
    private DefaultPromptTextField mergeTagsExceptField;
    private JLabel mergeTagsExceptLabel;
    private JCheckBox overwriteTagsCheckbox;
    private DefaultPromptTextField overwriteTagsField;
    private AutoCompletionList referenceTagsAutoCompletionList;

    public MergingPanel(AutoCompletionList referenceKeysAutocompletionList, IPreferences pref) {
        this.referenceTagsAutoCompletionList = referenceKeysAutocompletionList;
        this.initComponents();
    }

    private void initComponents() {
        this.replaceGeometryCheckBox = new JCheckBox(I18n.tr((String)"Replace Geometry", (Object[])new Object[0]));
        this.mergeTagsCheckBox = new JCheckBox(I18n.tr((String)"Merge Tags", (Object[])new Object[0]));
        this.mergeAllCheckBox = new JCheckBox(I18n.tr((String)"All", (Object[])new Object[0]));
        this.mergeTagsField = new DefaultPromptTextField(20, I18n.tr((String)"all", (Object[])new Object[0]));
        this.mergeTagsField.setToolTipText(I18n.tr((String)"List of tags to merge", (Object[])new Object[0]));
        this.mergeTagsField.setAutoCompletionList(this.referenceTagsAutoCompletionList);
        this.mergeTagsExceptLabel = new JLabel(I18n.tr((String)"except", (Object[])new Object[0]));
        this.mergeTagsExceptField = new DefaultPromptTextField(20, I18n.tr((String)"none", (Object[])new Object[0]));
        this.mergeTagsExceptField.setToolTipText(I18n.tr((String)"List of tags to NOT merge (they will be ignored)", (Object[])new Object[0]));
        this.mergeTagsExceptField.setAutoCompletionList(this.referenceTagsAutoCompletionList);
        if (ExpertToggleAction.isExpert()) {
            this.overwriteTagsCheckbox = new JCheckBox(I18n.tr((String)"Overwrite tags without confirmation", (Object[])new Object[0]));
            this.overwriteTagsField = new DefaultPromptTextField(20, I18n.tr((String)"none", (Object[])new Object[0]));
            this.overwriteTagsField.setToolTipText(I18n.tr((String)"List of tags to overwrite on conflict using reference layer without confirmation", (Object[])new Object[0]));
            this.overwriteTagsField.setAutoCompletionList(this.referenceTagsAutoCompletionList);
            this.overwriteTagsCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MergingPanel.this.overwriteTagsField.setEnabled(MergingPanel.this.overwriteTagsCheckbox.isSelected());
                }
            });
        }
        this.mergeTagsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enable = MergingPanel.this.mergeTagsCheckBox.isSelected();
                MergingPanel.this.mergeAllCheckBox.setEnabled(enable);
                MergingPanel.this.mergeTagsField.setEnabled(enable);
                MergingPanel.this.mergeTagsExceptLabel.setEnabled(enable);
                MergingPanel.this.mergeTagsExceptField.setEnabled(enable);
                if (enable) {
                    MergingPanel.this.mergeTagsField.setText("");
                    MergingPanel.this.mergeTagsExceptField.setText("");
                    MergingPanel.this.mergeAllCheckBox.setSelected(true);
                }
            }
        });
        this.mergeAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MergingPanel.this.mergeAllCheckBox.isSelected()) {
                    MergingPanel.this.mergeTagsField.setText("");
                    MergingPanel.this.mergeTagsExceptField.setText("");
                }
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            private void checkMergeAllCheckBox() {
                boolean noTags = SimpleMatchFinderPanel.splitBySpaceComaOrSemicolon(MergingPanel.this.mergeTagsField.getText()).isEmpty();
                boolean noExceptTags = SimpleMatchFinderPanel.splitBySpaceComaOrSemicolon(MergingPanel.this.mergeTagsExceptField.getText()).isEmpty();
                MergingPanel.this.mergeAllCheckBox.setSelected(noTags && noExceptTags);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkMergeAllCheckBox();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkMergeAllCheckBox();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkMergeAllCheckBox();
            }
        };
        this.mergeTagsField.getDocument().addDocumentListener(documentListener);
        this.mergeTagsExceptField.getDocument().addDocumentListener(documentListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        GroupLayout.ParallelGroup horizonatGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.replaceGeometryCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.mergeTagsCheckBox).addComponent(this.mergeAllCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addComponent((Component)((Object)this.mergeTagsField), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2).addComponent(this.mergeTagsExceptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2).addComponent((Component)((Object)this.mergeTagsExceptField), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 0, Short.MAX_VALUE));
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(this.replaceGeometryCheckBox).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mergeTagsCheckBox).addComponent(this.mergeAllCheckBox).addComponent((Component)((Object)this.mergeTagsField)).addComponent(this.mergeTagsExceptLabel).addComponent((Component)((Object)this.mergeTagsExceptField)));
        if (ExpertToggleAction.isExpert()) {
            horizonatGroup.addGroup(layout.createSequentialGroup().addComponent(this.overwriteTagsCheckbox).addComponent((Component)((Object)this.overwriteTagsField), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, Short.MAX_VALUE));
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.overwriteTagsCheckbox).addComponent((Component)((Object)this.overwriteTagsField)));
        }
        layout.setHorizontalGroup(horizonatGroup);
        layout.setVerticalGroup(verticalGroup);
    }

    public void savePreferences(IPreferences pref) {
        pref.putBoolean(this.getClass().getName() + ".replaceGeometryCheckBox", this.replaceGeometryCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".mergeTagsCheckBox", this.mergeTagsCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".mergeAllCheckBox", this.mergeAllCheckBox.isSelected());
        pref.put(this.getClass().getName() + ".mergeTagsField", this.mergeTagsField.getText());
        pref.put(this.getClass().getName() + ".mergeTagsExceptField", this.mergeTagsExceptField.getText());
        if (this.overwriteTagsCheckbox != null) {
            pref.putBoolean(this.getClass().getName() + ".overwriteTagsCheckbox", this.overwriteTagsCheckbox.isSelected());
            pref.put(this.getClass().getName() + ".overwriteTagsField", this.overwriteTagsField.getText());
        }
    }

    public void restoreFromPreferences(IPreferences pref) {
        this.replaceGeometryCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".replaceGeometryCheckBox", true));
        this.mergeTagsField.setText(pref.get(this.getClass().getName() + ".mergeTagsField", ""));
        this.mergeTagsExceptField.setText(pref.get(this.getClass().getName() + ".mergeTagsExceptField", ""));
        this.mergeAllCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".mergeAllCheckBox", true));
        this.mergeTagsCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".mergeTagsCheckBox", true));
        if (this.overwriteTagsCheckbox != null) {
            this.overwriteTagsField.setText(pref.get(this.getClass().getName() + ".overwriteTagsField", ""));
            this.overwriteTagsCheckbox.setSelected(pref.getBoolean(this.getClass().getName() + ".overwriteTagsCheckbox", false));
        }
    }

    public void fillSettings(SimpleMatchSettings settings) {
        settings.isReplacingGeometry = this.replaceGeometryCheckBox.isSelected();
        if (this.mergeTagsCheckBox.isSelected()) {
            List<String> tagsList = SimpleMatchFinderPanel.splitBySpaceComaOrSemicolon(this.mergeTagsField.getText());
            List<String> tagsExceptList = SimpleMatchFinderPanel.splitBySpaceComaOrSemicolon(this.mergeTagsExceptField.getText());
            settings.mergeTags = !tagsList.isEmpty() ? tagsList : new SimpleMatchSettings.All<String>();
            if (!tagsExceptList.isEmpty()) {
                settings.mergeTags.removeAll(tagsExceptList);
            }
        } else {
            settings.mergeTags = new ArrayList<String>(0);
        }
        settings.overwriteTags = this.overwriteTagsField != null && this.overwriteTagsCheckbox != null && this.overwriteTagsCheckbox.isSelected() ? SimpleMatchFinderPanel.splitBySpaceComaOrSemicolon(this.overwriteTagsField.getText()) : new ArrayList<String>(0);
    }
}

