/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.conflation.SimpleMatchSettings;
import org.openstreetmap.josm.plugins.conflation.config.AdvancedMatchFinderPanel;
import org.openstreetmap.josm.plugins.conflation.config.MatchFinderPanel;
import org.openstreetmap.josm.plugins.conflation.config.ProgrammingMatchFinderPanel;
import org.openstreetmap.josm.plugins.conflation.config.SettingsDialog;
import org.openstreetmap.josm.plugins.conflation.config.SimpleMatchFinderPanel;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;

public class MatchingPanel
extends JPanel {
    private SimpleMatchFinderPanel simpleMatchFinderPanel;
    private AdvancedMatchFinderPanel advancedMatchFinderPanel;
    private ProgrammingMatchFinderPanel programmingMatchFinderPanel;
    private Box selectedMatchFinderBox;
    private AutoCompletionList referenceTagsAutoCompletionList;
    private Runnable pack;

    public MatchingPanel(AutoCompletionList referenceKeysAutocompletionList, IPreferences pref, Runnable pack) {
        this.referenceTagsAutoCompletionList = referenceKeysAutocompletionList;
        this.pack = pack;
        this.initComponents(pref);
    }

    private void initComponents(IPreferences pref) {
        this.setLayout(new BorderLayout());
        this.simpleMatchFinderPanel = new SimpleMatchFinderPanel(this.referenceTagsAutoCompletionList, pref);
        this.advancedMatchFinderPanel = new AdvancedMatchFinderPanel(this.referenceTagsAutoCompletionList, pref);
        if (ExpertToggleAction.isExpert()) {
            this.programmingMatchFinderPanel = new ProgrammingMatchFinderPanel(pref);
        }
        final JRadioButton simpleRadioButton = new JRadioButton(I18n.tr((String)"Simple", (Object[])new Object[0]));
        final JRadioButton advancedRadioButton = new JRadioButton(I18n.tr((String)"Advanced", (Object[])new Object[0]));
        final JRadioButton programmimgRadioButton = new JRadioButton(I18n.tr((String)"Programming", (Object[])new Object[0]));
        simpleRadioButton.setFont(SettingsDialog.plainLabelFont);
        advancedRadioButton.setFont(SettingsDialog.plainLabelFont);
        programmimgRadioButton.setFont(SettingsDialog.plainLabelFont);
        ButtonGroup complexitySelectionBGroup = new ButtonGroup();
        complexitySelectionBGroup.add(simpleRadioButton);
        complexitySelectionBGroup.add(advancedRadioButton);
        complexitySelectionBGroup.add(programmimgRadioButton);
        simpleRadioButton.setSelected(true);
        Box complexitySelectionBox = Box.createHorizontalBox();
        complexitySelectionBox.setBorder(BorderFactory.createLoweredBevelBorder());
        complexitySelectionBox.add(simpleRadioButton);
        complexitySelectionBox.add(advancedRadioButton);
        if (this.programmingMatchFinderPanel != null) {
            complexitySelectionBox.add(programmimgRadioButton);
        }
        this.selectedMatchFinderBox = Box.createHorizontalBox();
        this.selectedMatchFinderBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.selectedMatchFinderBox.add(this.simpleMatchFinderPanel);
        ActionListener modeChangedLiseter = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Component currentComponent;
                MatchFinderPanel componentToSelect = null;
                if (event.getSource() == simpleRadioButton) {
                    componentToSelect = MatchingPanel.this.simpleMatchFinderPanel;
                } else if (event.getSource() == advancedRadioButton) {
                    componentToSelect = MatchingPanel.this.advancedMatchFinderPanel;
                } else if (event.getSource() == programmimgRadioButton) {
                    componentToSelect = MatchingPanel.this.programmingMatchFinderPanel;
                }
                Component component = currentComponent = MatchingPanel.this.selectedMatchFinderBox.getComponentCount() > 0 ? MatchingPanel.this.selectedMatchFinderBox.getComponent(0) : null;
                if (componentToSelect != currentComponent && componentToSelect != null) {
                    MatchingPanel.this.selectedMatchFinderBox.remove(0);
                    MatchingPanel.this.selectedMatchFinderBox.add(componentToSelect);
                    MatchingPanel.this.selectedMatchFinderBox.revalidate();
                    MatchingPanel.this.pack.run();
                    MatchingPanel.this.selectedMatchFinderBox.repaint();
                }
            }
        };
        simpleRadioButton.addActionListener(modeChangedLiseter);
        advancedRadioButton.addActionListener(modeChangedLiseter);
        programmimgRadioButton.addActionListener(modeChangedLiseter);
        Box box = Box.createVerticalBox();
        box.add(complexitySelectionBox);
        box.add(Box.createRigidArea(new Dimension(1, 5)));
        box.add(this.selectedMatchFinderBox);
        this.add((Component)box, "Center");
    }

    MatchFinderPanel getSelectedMatchFinderPanel() {
        return (MatchFinderPanel)this.selectedMatchFinderBox.getComponent(0);
    }

    public void savePreferences(IPreferences pref) {
        this.simpleMatchFinderPanel.savePreferences(pref);
        this.advancedMatchFinderPanel.savePreferences(pref);
        if (this.programmingMatchFinderPanel != null) {
            this.programmingMatchFinderPanel.savePreferences(pref);
        }
    }

    public void restoreFromPreferences(IPreferences pref) {
        this.simpleMatchFinderPanel.restoreFromPreferences(pref);
        this.advancedMatchFinderPanel.restoreFromPreferences(pref);
        if (this.programmingMatchFinderPanel != null) {
            this.programmingMatchFinderPanel.restoreFromPreferences(pref);
        }
    }

    public void fillSettings(SimpleMatchSettings settings) {
        settings.matchFinder = this.getSelectedMatchFinderPanel().getMatchFinder();
    }
}

