/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;

public class DefaultPromptTextField
extends AutoCompletingTextField {
    String promptText;

    public DefaultPromptTextField(int column, String promptText) {
        super(column);
        this.promptText = promptText;
    }

    public void setPrompt(String newPromptText) {
        this.promptText = newPromptText;
        this.invalidate();
    }

    public String getPrompt() {
        return this.promptText;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.hasFocus() && this.getText().isEmpty()) {
            Graphics2D g2 = (Graphics2D)g;
            Font font = this.getFont().deriveFont(2);
            g2.setFont(font);
            g2.setColor(this.getDisabledTextColor());
            Rectangle2D rect = font.getStringBounds(this.promptText, g2.getFontRenderContext());
            g2.drawString(this.promptText, (this.getWidth() - (int)rect.getWidth()) / 2, this.getBaseline(this.getWidth(), this.getHeight()));
        }
    }
}

