/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.config;

import com.vividsolutions.jcs.conflate.polygonmatch.AbstractDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.AngleHistogramMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.AreaFilterFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.BasicFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.CentroidAligner;
import com.vividsolutions.jcs.conflate.polygonmatch.CentroidDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.ChainMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.CompactnessMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.DisambiguatingFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.FeatureMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.HausdorffDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.IdenticalFeatureFilter;
import com.vividsolutions.jcs.conflate.polygonmatch.SymDiffMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.TargetUnioningFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.WeightedMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.WindowFilter;
import com.vividsolutions.jcs.plugin.conflate.polygonmatch.MyValidatingTextField;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.conflation.config.DefaultPromptTextField;
import org.openstreetmap.josm.plugins.conflation.config.MatchFinderPanel;
import org.openstreetmap.josm.plugins.conflation.config.SimpleMatchFinderPanel;
import org.openstreetmap.josm.plugins.conflation.matcher.AttributeMatcher;
import org.openstreetmap.josm.plugins.conflation.matcher.ExactValueMatcher;
import org.openstreetmap.josm.plugins.conflation.matcher.LevenshteinDistanceValueMatcher;
import org.openstreetmap.josm.plugins.conflation.matcher.OsmNormalizeRule;
import org.openstreetmap.josm.plugins.conflation.matcher.StandardDistanceMatcher;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedMatchFinderPanel
extends MatchFinderPanel {
    private JTabbedPane upperTabbedPane = new JTabbedPane();
    private JPanel filteringTab = new JPanel();
    private JPanel unioningTab = new JPanel();
    private JPanel matchingTab = new JPanel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private JPanel filterByAreaPanel = new JPanel();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private JCheckBox filterByAreaCheckBox = new JCheckBox("", true);
    private MyValidatingTextField filterByAreaMinField = new MyValidatingTextField("0", 4, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private MyValidatingTextField filterByAreaMaxField = new MyValidatingTextField("9E6", 4, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JLabel filterByAreaLabel2 = new JLabel();
    private JLabel filterByAreaLabel1 = new JLabel();
    private JPanel filterByWindowPanel = new JPanel();
    private GridBagLayout gridBagLayout7 = new GridBagLayout();
    private JCheckBox filterByWindowCheckBox = new JCheckBox("", true);
    private JLabel filterByWindowLabel = new JLabel();
    private MyValidatingTextField filterByWindowField = new MyValidatingTextField("50", 4, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JCheckBox unionCheckBox = new JCheckBox("", false);
    private JLabel unionLabel1 = new JLabel();
    private MyValidatingTextField unionTextField = new MyValidatingTextField("2", 1, new MyValidatingTextField.CompositeValidator(new ValidatingTextField.Validator[]{MyValidatingTextField.NON_NEGATIVE_INTEGER_VALIDATOR, new MyValidatingTextField.GreaterThanValidator(1.5)}), "2");
    private JLabel unionLabel2 = new JLabel();
    private MyValidatingTextField angleBinField = new MyValidatingTextField("18", 3, new MyValidatingTextField.CompositeValidator(new ValidatingTextField.Validator[]{MyValidatingTextField.NON_NEGATIVE_INTEGER_VALIDATOR, new MyValidatingTextField.GreaterThanValidator(1.5)}), "2");
    private JLabel weightLabel = new JLabel();
    private JCheckBox stdDistanceCheckBox = new JCheckBox("", true);
    private MyValidatingTextField stdDistanceWeightField = new MyValidatingTextField("10", 3, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JPanel stdDistancePanel = new JPanel();
    private GridBagLayout stdDistanceLayout = new GridBagLayout();
    private JLabel stdDistanceLabel = new JLabel();
    private JLabel stdDistanceBelow = new JLabel();
    private MyValidatingTextField stdDistanceThresholdField = new MyValidatingTextField("50", 4, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "");
    private JCheckBox centroidCheckBox = new JCheckBox("", true);
    private MyValidatingTextField centroidDistanceWeightField = new MyValidatingTextField("10", 3, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JPanel centroidPanel = new JPanel();
    private GridBagLayout centroidLayout = new GridBagLayout();
    private JLabel centroidLabel = new JLabel();
    private JLabel centroidBelow = new JLabel();
    private MyValidatingTextField centroidThresholdField = new MyValidatingTextField("50", 4, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "");
    private JCheckBox hausdorffCheckBox = new JCheckBox("", true);
    private MyValidatingTextField hausdorffDistanceWeightField = new MyValidatingTextField("10", 3, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JLabel hausdorffLabel = new JLabel();
    private JCheckBox symDiffCheckBox = new JCheckBox("", true);
    private MyValidatingTextField symDiffWeightField = new MyValidatingTextField("10", 3, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JLabel symDiffLabel = new JLabel();
    private JCheckBox symDiffCentroidsAlignedCheckBox = new JCheckBox("", true);
    private MyValidatingTextField symDiffCentroidsAlignedWeightField = new MyValidatingTextField("10", 3, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JLabel symDiffCentroidsAlignedLabel = new JLabel();
    private JCheckBox compactnessCheckBox = new JCheckBox("", true);
    private MyValidatingTextField compactnessWeightField = new MyValidatingTextField("10", 3, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JLabel compactnessLabel = new JLabel();
    private JCheckBox angleCheckBox = new JCheckBox("", true);
    private MyValidatingTextField angleWeightField = new MyValidatingTextField("10", 3, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JPanel anglePanel = new JPanel();
    private GridBagLayout gridBagLayout8 = new GridBagLayout();
    private JLabel angleLabel = new JLabel();
    private JPanel matchingFillerPanel = new JPanel();
    private JTextArea filterByAreaTextArea = new JTextArea();
    private JTextArea unioningTextArea = new JTextArea();
    private GridBagLayout exactTagsdLayout = new GridBagLayout();
    private GridBagLayout levenshteinTagsLayout = new GridBagLayout();
    private JPanel exactTagsPanel = new JPanel();
    private JPanel levenshteinTagsPanel = new JPanel();
    private JCheckBox levenshteinTagsCheckBox = new JCheckBox("", true);
    private MyValidatingTextField levenshteinTagsWeightField = new MyValidatingTextField("50", 3, MyValidatingTextField.NON_NEGATIVE_DOUBLE_VALIDATOR, "0");
    private JLabel exactTagsLabel = new JLabel();
    private JLabel levenshteinTagsLabel = new JLabel();
    private DefaultPromptTextField exactTagsField = new DefaultPromptTextField(15, I18n.tr((String)"none", (Object[])new Object[0]));
    private DefaultPromptTextField levenshteinTagsField = new DefaultPromptTextField(15, I18n.tr((String)"none", (Object[])new Object[0]));
    private JCheckBox identicalCheckBox = new JCheckBox("", true);

    public AdvancedMatchFinderPanel(AutoCompletionList referenceKeysAutocompletionList, IPreferences pref) {
        this.filterByAreaTextArea.setFont(this.angleLabel.getFont().deriveFont(2));
        this.unioningTextArea.setFont(this.angleLabel.getFont().deriveFont(2));
        this.handleLabelClicks();
        this.jbInit();
        this.exactTagsField.setAutoCompletionList(referenceKeysAutocompletionList);
        this.levenshteinTagsField.setAutoCompletionList(referenceKeysAutocompletionList);
        this.restoreFromPreferences(pref);
    }

    public MyValidatingTextField getAngleBinField() {
        return this.angleBinField;
    }

    public JCheckBox getAngleCheckBox() {
        return this.angleCheckBox;
    }

    public MyValidatingTextField getAngleWeightField() {
        return this.angleWeightField;
    }

    public JCheckBox getCentroidCheckBox() {
        return this.centroidCheckBox;
    }

    public MyValidatingTextField getCentroidDistanceWeightField() {
        return this.centroidDistanceWeightField;
    }

    public JCheckBox getCompactnessCheckBox() {
        return this.compactnessCheckBox;
    }

    public MyValidatingTextField getCompactnessWeightField() {
        return this.compactnessWeightField;
    }

    public JCheckBox getHausdorffCheckBox() {
        return this.hausdorffCheckBox;
    }

    public MyValidatingTextField getHausdorffDistanceWeightField() {
        return this.hausdorffDistanceWeightField;
    }

    public JCheckBox getSymDiffCheckBox() {
        return this.symDiffCheckBox;
    }

    public MyValidatingTextField getSymDiffWeightField() {
        return this.symDiffWeightField;
    }

    public JCheckBox getSymDiffCentroidsAlignedCheckBox() {
        return this.symDiffCentroidsAlignedCheckBox;
    }

    public MyValidatingTextField getSymDiffCentroidsAlignedWeightField() {
        return this.symDiffCentroidsAlignedWeightField;
    }

    public void setFilterByAreaMaxField(MyValidatingTextField filterByAreaMaxField) {
        this.filterByAreaMaxField = filterByAreaMaxField;
    }

    public void setFilterByAreaMinField(MyValidatingTextField filterByAreaMinField) {
        this.filterByAreaMinField = filterByAreaMinField;
    }

    public void setFilterByWindowCheckBox(JCheckBox filterByWindowCheckBox) {
        this.filterByWindowCheckBox = filterByWindowCheckBox;
    }

    public void setUnionTextField(MyValidatingTextField unionTextField) {
        this.unionTextField = unionTextField;
    }

    public JCheckBox getFilterByAreaCheckBox() {
        return this.filterByAreaCheckBox;
    }

    public MyValidatingTextField getFilterByAreaMaxField() {
        return this.filterByAreaMaxField;
    }

    public MyValidatingTextField getFilterByAreaMinField() {
        return this.filterByAreaMinField;
    }

    public JCheckBox getFilterByWindowCheckBox() {
        return this.filterByWindowCheckBox;
    }

    public MyValidatingTextField getFilterByWindowField() {
        return this.filterByWindowField;
    }

    public JCheckBox getUnionCheckBox() {
        return this.unionCheckBox;
    }

    public MyValidatingTextField getUnionTextField() {
        return this.unionTextField;
    }

    private void handleLabelClicks() {
        this.handleClicks(this.filterByWindowLabel, this.filterByWindowCheckBox);
        this.handleClicks(this.filterByAreaLabel1, this.filterByAreaCheckBox);
        this.handleClicks(this.unionLabel1, this.unionCheckBox);
    }

    private void handleClicks(JLabel label, final JCheckBox checkBox) {
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                checkBox.doClick();
            }
        });
    }

    private void jbInit() {
        this.setLayout(new BoxLayout(this, 1));
        this.filteringTab.setLayout(this.gridBagLayout3);
        this.unioningTab.setLayout(this.gridBagLayout4);
        this.matchingTab.setLayout(this.gridBagLayout5);
        this.filterByAreaPanel.setLayout(this.gridBagLayout6);
        this.filterByAreaLabel2.setText(I18n.tr((String)" Max: ", (Object[])new Object[0]));
        this.filterByAreaLabel1.setText(I18n.tr((String)"Filter by area. Min: ", (Object[])new Object[0]));
        this.filterByWindowPanel.setLayout(this.gridBagLayout7);
        this.filterByWindowLabel.setText(I18n.tr((String)"Filter by window. Buffer: ", (Object[])new Object[0]));
        this.unionLabel1.setText(I18n.tr((String)"Union up to ", (Object[])new Object[0]));
        this.unionLabel2.setText(I18n.tr((String)" adjacent Reference features", (Object[])new Object[0]));
        this.weightLabel.setText(I18n.tr((String)"Weight", (Object[])new Object[0]));
        this.stdDistanceLabel.setText(I18n.tr((String)"Standard Distance", (Object[])new Object[0]));
        this.stdDistancePanel.setLayout(this.stdDistanceLayout);
        this.stdDistanceBelow.setText(" < ");
        this.stdDistanceBelow.setToolTipText(I18n.tr((String)"below", (Object[])new Object[0]));
        this.stdDistanceThresholdField.setToolTipText(I18n.tr((String)"Maximum Distance", (Object[])new Object[0]));
        this.centroidLabel.setText(I18n.tr((String)"Centroid Distance", (Object[])new Object[0]));
        this.centroidPanel.setLayout(this.centroidLayout);
        this.centroidBelow.setText(" < ");
        this.centroidBelow.setToolTipText(I18n.tr((String)"below", (Object[])new Object[0]));
        this.centroidThresholdField.setToolTipText(I18n.tr((String)"Maximum Distance", (Object[])new Object[0]));
        this.hausdorffLabel.setText(I18n.tr((String)"Hausdorff Distance (Centroids Aligned)", (Object[])new Object[0]));
        this.symDiffLabel.setText(I18n.tr((String)"Symmetric Difference", (Object[])new Object[0]));
        this.symDiffCentroidsAlignedLabel.setText(I18n.tr((String)"Symmetric Difference (Centroids Aligned)", (Object[])new Object[0]));
        this.compactnessLabel.setText(I18n.tr((String)"Compactness", (Object[])new Object[0]));
        this.anglePanel.setLayout(this.gridBagLayout8);
        this.angleLabel.setText(I18n.tr((String)"Angle Histogram. Bins: ", (Object[])new Object[0]));
        this.exactTagsPanel.setLayout(this.exactTagsdLayout);
        this.levenshteinTagsPanel.setLayout(this.levenshteinTagsLayout);
        this.exactTagsLabel.setText(I18n.tr((String)"Tags (Exact Match): ", (Object[])new Object[0]));
        this.levenshteinTagsLabel.setText(I18n.tr((String)"Tags (Levenshtein Distance): ", (Object[])new Object[0]));
        this.levenshteinTagsField.setToolTipText(I18n.tr((String)"List of tags to match", (Object[])new Object[0]));
        this.exactTagsField.setToolTipText(I18n.tr((String)"List of tags to match", (Object[])new Object[0]));
        this.identicalCheckBox.setText(I18n.tr((String)"Identical Elements Filter", (Object[])new Object[0]));
        this.identicalCheckBox.setToolTipText(I18n.tr((String)"Avoid matching an element with itself", (Object[])new Object[0]));
        this.filterByAreaTextArea.setEnabled(false);
        this.filterByAreaTextArea.setBorder(null);
        this.filterByAreaTextArea.setOpaque(false);
        this.filterByAreaTextArea.setDisabledTextColor(Color.black);
        this.filterByAreaTextArea.setEditable(false);
        this.filterByAreaTextArea.setText(I18n.tr((String)"Filtering will speed up the matching process. Filter By Window weeds out matches between features whose envelopes do not overlap. Filter By Area is used to weed out very small and very large features.", (Object[])new Object[0]));
        this.filterByAreaTextArea.setLineWrap(true);
        this.filterByAreaTextArea.setWrapStyleWord(true);
        this.unioningTextArea.setWrapStyleWord(true);
        this.unioningTextArea.setLineWrap(true);
        this.unioningTextArea.setText(I18n.tr((String)"Better matches may be found by creating temporary unions of features sharing a common edge.", (Object[])new Object[0]));
        this.unioningTextArea.setEditable(false);
        this.unioningTextArea.setDisabledTextColor(Color.black);
        this.unioningTextArea.setOpaque(false);
        this.unioningTextArea.setBorder(null);
        this.unioningTextArea.setEnabled(false);
        this.add(this.upperTabbedPane);
        this.filteringTab.add((Component)this.filterByAreaPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.upperTabbedPane.add((Component)this.matchingTab, I18n.tr((String)"Matching", (Object[])new Object[0]));
        this.upperTabbedPane.add((Component)this.filteringTab, I18n.tr((String)"Filtering", (Object[])new Object[0]));
        this.upperTabbedPane.add((Component)this.unioningTab, I18n.tr((String)"Unioning", (Object[])new Object[0]));
        this.matchingTab.add((Component)this.weightLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterByAreaPanel.add((Component)this.filterByAreaMinField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterByAreaPanel.add((Component)this.filterByAreaMaxField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterByAreaPanel.add((Component)this.filterByAreaLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterByAreaPanel.add((Component)this.filterByAreaLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterByAreaPanel.add((Component)this.filterByAreaCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filteringTab.add((Component)this.filterByWindowPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterByWindowPanel.add((Component)this.filterByWindowCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterByWindowPanel.add((Component)this.filterByWindowLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterByWindowPanel.add((Component)this.filterByWindowField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unioningTab.add((Component)this.unionCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unioningTab.add((Component)this.unionLabel1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unioningTab.add((Component)this.unionTextField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unioningTab.add((Component)this.unionLabel2, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unioningTab.add((Component)this.unioningTextArea, new GridBagConstraints(0, 10, 10, 1, 1.0, 1.0, 10, 1, new Insets(10, 4, 4, 4), 0, 0));
        this.filteringTab.add((Component)this.identicalCheckBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filteringTab.add((Component)this.filterByAreaTextArea, new GridBagConstraints(1, 10, 2, 2, 1.0, 1.0, 10, 1, new Insets(10, 4, 4, 4), 0, 0));
        this.matchingTab.add((Component)this.stdDistanceCheckBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.stdDistanceWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.stdDistancePanel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.centroidCheckBox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.centroidDistanceWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.centroidPanel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.hausdorffCheckBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.hausdorffDistanceWeightField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.hausdorffLabel, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.symDiffCheckBox, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.symDiffWeightField, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.symDiffLabel, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.symDiffCentroidsAlignedCheckBox, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.symDiffCentroidsAlignedWeightField, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.symDiffCentroidsAlignedLabel, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.compactnessCheckBox, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.compactnessWeightField, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.compactnessLabel, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.angleCheckBox, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.angleWeightField, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.anglePanel, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.levenshteinTagsCheckBox, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.levenshteinTagsWeightField, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.levenshteinTagsPanel, new GridBagConstraints(4, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.exactTagsPanel, new GridBagConstraints(2, 9, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.anglePanel.add((Component)this.angleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.anglePanel.add((Component)this.angleBinField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchingTab.add((Component)this.matchingFillerPanel, new GridBagConstraints(50, 50, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.stdDistancePanel.add((Component)this.stdDistanceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.stdDistancePanel.add((Component)this.stdDistanceBelow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.stdDistancePanel.add((Component)this.stdDistanceThresholdField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centroidPanel.add((Component)this.centroidLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centroidPanel.add((Component)this.centroidBelow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centroidPanel.add((Component)this.centroidThresholdField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.exactTagsPanel.add((Component)this.exactTagsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.exactTagsPanel.add((Component)((Object)this.exactTagsField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.levenshteinTagsPanel.add((Component)this.levenshteinTagsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.levenshteinTagsPanel.add((Component)((Object)this.levenshteinTagsField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public FeatureMatcher createFeatureMatcher() {
        AbstractDistanceMatcher matcher;
        double max;
        ArrayList<FeatureMatcher> chainArgs = new ArrayList<FeatureMatcher>();
        ArrayList<Object> weightedArgs = new ArrayList<Object>();
        if (this.getFilterByWindowCheckBox().isSelected()) {
            chainArgs.add(new WindowFilter(this.filterByWindowField.getDouble()));
        }
        if (this.stdDistanceCheckBox.isSelected()) {
            max = this.stdDistanceThresholdField.getDouble();
            matcher = new StandardDistanceMatcher(max);
            if (max > 0.0) {
                chainArgs.add(matcher);
            }
            weightedArgs.add(this.stdDistanceWeightField.getDouble());
            weightedArgs.add(matcher);
        }
        if (this.getCentroidCheckBox().isSelected()) {
            max = this.centroidThresholdField.getDouble();
            matcher = new CentroidDistanceMatcher(max);
            if (max > 0.0) {
                chainArgs.add(matcher);
            }
            weightedArgs.add(this.getCentroidDistanceWeightField().getDouble());
            weightedArgs.add(matcher);
        }
        if (this.getHausdorffCheckBox().isSelected()) {
            weightedArgs.add(this.getHausdorffDistanceWeightField().getDouble());
            weightedArgs.add(new CentroidAligner(new HausdorffDistanceMatcher()));
        }
        if (this.getSymDiffCheckBox().isSelected()) {
            weightedArgs.add(this.getSymDiffWeightField().getDouble());
            weightedArgs.add(new SymDiffMatcher());
        }
        if (this.getSymDiffCentroidsAlignedCheckBox().isSelected()) {
            weightedArgs.add(this.getSymDiffCentroidsAlignedWeightField().getDouble());
            weightedArgs.add(new CentroidAligner(new SymDiffMatcher()));
        }
        if (this.getCompactnessCheckBox().isSelected()) {
            weightedArgs.add(this.getCompactnessWeightField().getDouble());
            weightedArgs.add(new CompactnessMatcher());
        }
        if (this.getAngleCheckBox().isSelected()) {
            weightedArgs.add(this.getAngleWeightField().getDouble());
            weightedArgs.add(new AngleHistogramMatcher(this.getAngleBinField().getInteger()));
        }
        if (this.levenshteinTagsCheckBox.isSelected()) {
            double weight = this.levenshteinTagsWeightField.getDouble();
            List<String> tags = SimpleMatchFinderPanel.splitBySpaceComaOrSemicolon(this.levenshteinTagsField.getText());
            for (String tag : tags) {
                weightedArgs.add(weight / (double)tags.size());
                weightedArgs.add(new AttributeMatcher(tag, LevenshteinDistanceValueMatcher.INSTANCE, OsmNormalizeRule.get(tag)));
            }
        }
        List<String> exactTags = SimpleMatchFinderPanel.splitBySpaceComaOrSemicolon(this.exactTagsField.getText());
        for (String tag : exactTags) {
            chainArgs.add(new AttributeMatcher(tag, ExactValueMatcher.INSTANCE, new SimilarNamedWays.NormalizeRule[0]));
        }
        chainArgs.add(new WeightedMatcher(weightedArgs.toArray()));
        if (this.identicalCheckBox.isSelected()) {
            chainArgs.add(new IdenticalFeatureFilter());
        }
        return new ChainMatcher(chainArgs.toArray(new FeatureMatcher[chainArgs.size()]));
    }

    @Override
    public FCMatchFinder getMatchFinder() {
        FCMatchFinder matchFinder = new BasicFCMatchFinder(this.createFeatureMatcher());
        matchFinder = new DisambiguatingFCMatchFinder(matchFinder);
        TargetUnioningFCMatchFinder targetUnioningFCMatchFinder = null;
        if (this.getUnionCheckBox().isSelected()) {
            int maxUnionMembers = Integer.parseInt(this.getUnionTextField().getText());
            targetUnioningFCMatchFinder = new TargetUnioningFCMatchFinder(maxUnionMembers, matchFinder);
            matchFinder = targetUnioningFCMatchFinder;
        }
        if (this.getFilterByAreaCheckBox().isSelected()) {
            matchFinder = new AreaFilterFCMatchFinder(this.getFilterByAreaMinField().getDouble(), this.getFilterByAreaMaxField().getDouble(), matchFinder);
        }
        return matchFinder;
    }

    @Override
    public void savePreferences(IPreferences pref) {
        pref.putBoolean(this.getClass().getName() + ".filterByAreaCheckBox", this.filterByAreaCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".filterByWindowCheckBox", this.filterByWindowCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".unionCheckBox", this.unionCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".stdDistanceCheckBox", this.stdDistanceCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".centroidCheckBox", this.centroidCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".hausdorffCheckBox", this.hausdorffCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".symDiffCheckBox", this.symDiffCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".symDiffCentroidsAlignedCheckBox", this.symDiffCentroidsAlignedCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".compactnessCheckBox", this.compactnessCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".angleCheckBox", this.angleCheckBox.isSelected());
        pref.putBoolean(this.getClass().getName() + ".levenshteinTagsCheckBox", this.levenshteinTagsCheckBox.isSelected());
        pref.putInt(this.getClass().getName() + ".unionTextField", this.unionTextField.getInteger());
        pref.putInt(this.getClass().getName() + ".angleBinField", this.angleBinField.getInteger());
        pref.putDouble(this.getClass().getName() + ".filterByAreaMinField", this.filterByAreaMinField.getDouble());
        pref.putDouble(this.getClass().getName() + ".filterByAreaMaxField", this.filterByAreaMaxField.getDouble());
        pref.putDouble(this.getClass().getName() + ".filterByWindowField", this.filterByWindowField.getDouble());
        pref.putDouble(this.getClass().getName() + ".stdDistanceWeightField", this.stdDistanceWeightField.getDouble());
        pref.putDouble(this.getClass().getName() + ".stdDistanceThresholdField", this.stdDistanceThresholdField.getDouble());
        pref.putDouble(this.getClass().getName() + ".centroidDistanceWeightField", this.centroidDistanceWeightField.getDouble());
        pref.putDouble(this.getClass().getName() + ".centroidThresholdField", this.centroidThresholdField.getDouble());
        pref.putDouble(this.getClass().getName() + ".hausdorffDistanceWeightField", this.hausdorffDistanceWeightField.getDouble());
        pref.putDouble(this.getClass().getName() + ".symDiffWeightField", this.symDiffWeightField.getDouble());
        pref.putDouble(this.getClass().getName() + ".symDiffCentroidsAlignedWeightField", this.symDiffCentroidsAlignedWeightField.getDouble());
        pref.putDouble(this.getClass().getName() + ".compactnessWeightField", this.compactnessWeightField.getDouble());
        pref.putDouble(this.getClass().getName() + ".angleWeightField", this.angleWeightField.getDouble());
        pref.putDouble(this.getClass().getName() + ".levenshteinTagsWeightField", this.levenshteinTagsWeightField.getDouble());
        pref.put(this.getClass().getName() + ".exactTagsField", this.exactTagsField.getText());
        pref.put(this.getClass().getName() + ".levenshteinTagsField", this.levenshteinTagsField.getText());
        pref.putBoolean(this.getClass().getName() + ".identicalCheckBox", this.identicalCheckBox.isSelected());
    }

    public void restoreFromPreferences(IPreferences pref) {
        this.filterByAreaCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".filterByAreaCheckBox", true));
        this.filterByWindowCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".filterByWindowCheckBox", true));
        this.unionCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".unionCheckBox", false));
        this.stdDistanceCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".stdDistanceCheckBox", true));
        this.centroidCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".centroidCheckBox", true));
        this.hausdorffCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".hausdorffCheckBox", true));
        this.symDiffCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".symDiffCheckBox", true));
        this.symDiffCentroidsAlignedCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".symDiffCentroidsAlignedCheckBox", true));
        this.compactnessCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".compactnessCheckBox", true));
        this.angleCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".angleCheckBox", true));
        this.levenshteinTagsCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".levenshteinTagsCheckBox", true));
        this.unionTextField.setText("" + Integer.max(2, pref.getInt(this.getClass().getName() + ".unionTextField", 2)));
        this.angleBinField.setText("" + Integer.max(2, pref.getInt(this.getClass().getName() + ".angleBinField", 18)));
        this.filterByAreaMinField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".filterByAreaMinField", 0.0)));
        this.filterByAreaMaxField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".filterByAreaMaxField", 9000000.0)));
        this.filterByWindowField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".filterByWindowField", 50.0)));
        this.stdDistanceWeightField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".stdDistanceWeightField", 10.0)));
        this.stdDistanceThresholdField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".stdDistanceThresholdField", 50.0)));
        this.centroidDistanceWeightField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".centroidDistanceWeightField", 10.0)));
        this.centroidThresholdField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".centroidThresholdField", 50.0)));
        this.hausdorffDistanceWeightField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".hausdorffDistanceWeightField", 10.0)));
        this.symDiffWeightField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".symDiffWeightField", 10.0)));
        this.symDiffCentroidsAlignedWeightField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".symDiffCentroidsAlignedWeightField", 10.0)));
        this.compactnessWeightField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".compactnessWeightField", 10.0)));
        this.angleWeightField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".angleWeightField", 10.0)));
        this.levenshteinTagsWeightField.setText("" + Double.max(0.0, pref.getDouble(this.getClass().getName() + ".levenshteinTagsWeightField", 50.0)));
        this.exactTagsField.setText(pref.get(this.getClass().getName() + ".exactTagsField", ""));
        this.levenshteinTagsField.setText(pref.get(this.getClass().getName() + ".levenshteinTagsField", ""));
        this.identicalCheckBox.setSelected(pref.getBoolean(this.getClass().getName() + ".identicalCheckBox", false));
    }
}

