/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class StopOnErrorSequenceCommand
extends Command {
    protected final String name;
    protected final Command[] sequence;
    protected final HashSet<OsmPrimitive> selection;
    protected int nbToExecute;

    public StopOnErrorSequenceCommand(DataSet data, String name, boolean combineSelection, Command ... sequenz) {
        this(data, name, combineSelection, (Command[])sequenz.clone(), sequenz.length);
    }

    public StopOnErrorSequenceCommand(DataSet data, String name, boolean combineSelection, Collection<Command> sequenz) {
        this(data, name, combineSelection, sequenz.toArray(new Command[sequenz.size()]), sequenz.size());
    }

    private StopOnErrorSequenceCommand(DataSet data, String name, boolean combineSelection, Command[] sequence, int nbToExecute) {
        super(data);
        this.name = name;
        this.sequence = sequence;
        this.nbToExecute = nbToExecute;
        this.selection = combineSelection ? new HashSet() : null;
    }

    public boolean executeCommand() {
        int count;
        if (this.selection != null) {
            this.selection.clear();
        }
        try {
            for (count = 0; count < this.nbToExecute && this.sequence[count].executeCommand(); ++count) {
                if (this.selection == null) continue;
                this.selection.addAll(this.getAffectedDataSet().getSelected());
            }
        }
        catch (RuntimeException e) {
            this.nbToExecute = count;
            this.undoCommand();
            this.nbToExecute = 0;
            throw e;
        }
        if (this.selection != null && !this.selection.isEmpty()) {
            this.getAffectedDataSet().setSelected(this.selection);
        }
        this.nbToExecute = count;
        return count > 0;
    }

    public void undoCommand() {
        for (int i = this.nbToExecute - 1; i >= 0; --i) {
            this.sequence[i].undoCommand();
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        throw new UnsupportedOperationException();
    }

    public String getDescriptionText() {
        if (this.nbToExecute == this.sequence.length) {
            return I18n.tr((String)I18n.marktr((String)"Sequence: {0}"), (Object[])new Object[]{this.name});
        }
        return I18n.tr((String)I18n.marktr((String)"Interrupted Sequence ({0}/{1}): {2}"), (Object[])new Object[]{this.nbToExecute, this.sequence.length, this.name});
    }

    public Icon getDescriptionIcon() {
        return ImageProvider.get((String)"data", (String)"sequence");
    }

    public Collection<PseudoCommand> getChildren() {
        return Arrays.asList((PseudoCommand[])Arrays.copyOf(this.sequence, this.nbToExecute));
    }

    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet prims = new HashSet();
        for (int i = 0; i < this.nbToExecute; ++i) {
            prims.addAll(this.sequence[i].getParticipatingPrimitives());
        }
        return prims;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.sequence), this.nbToExecute, this.selection != null, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StopOnErrorSequenceCommand that = (StopOnErrorSequenceCommand)((Object)obj);
        return this.nbToExecute == that.nbToExecute && this.selection != null == (that.selection != null) && Arrays.equals(this.sequence, that.sequence) && Objects.equals(this.name, that.name);
    }
}

