/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.command;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.I18n;

public class SetSelectedCommand
extends Command {
    private Collection<? extends PrimitiveId> objects;
    private Collection<OsmPrimitive> newSelection;
    private Collection<OsmPrimitive> oldSelection;

    public SetSelectedCommand(DataSet dataset, Collection<? extends PrimitiveId> objects) {
        super(dataset);
        this.objects = objects;
    }

    public boolean executeCommand() {
        DataSet ds = this.getAffectedDataSet();
        this.oldSelection = ds.getSelected();
        if (this.newSelection == null) {
            this.newSelection = this.objects.stream().map(arg_0 -> ((DataSet)ds).getPrimitiveById(arg_0)).collect(Collectors.toList());
            this.objects = null;
        }
        ds.setSelected(this.newSelection);
        return true;
    }

    public void undoCommand() {
        this.getAffectedDataSet().setSelected(this.oldSelection);
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        int size = this.newSelection != null ? this.newSelection.size() : 0;
        return I18n.trn((String)"Selected {0} object", (String)"Selected {0} objects", (long)size, (Object[])new Object[]{size});
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.objects, this.newSelection, this.oldSelection);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SetSelectedCommand that = (SetSelectedCommand)((Object)obj);
        return Objects.equals(this.objects, that.objects) && Objects.equals(this.newSelection, that.newSelection) && Objects.equals(this.oldSelection, that.oldSelection);
    }
}

