/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.conflation.UnmatchedObjectListModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RemoveUnmatchedObjectCommand
extends Command {
    private final UnmatchedObjectListModel model;
    private final Collection<OsmPrimitive> objects;

    public RemoveUnmatchedObjectCommand(UnmatchedObjectListModel model, Collection<OsmPrimitive> objects) {
        super(MainApplication.getLayerManager().getEditDataSet());
        this.model = model;
        this.objects = objects;
    }

    public boolean executeCommand() {
        boolean res = false;
        this.model.beginUpdate();
        try {
            res = this.model.removeAll(this.objects);
        }
        finally {
            this.model.endUpdate();
        }
        return res;
    }

    public void undoCommand() {
        this.model.beginUpdate();
        try {
            this.model.addAll(this.objects);
        }
        finally {
            this.model.endUpdate();
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)I18n.marktr((String)"Remove {0} unmatched objects"), (Object[])new Object[]{this.objects.size()});
    }

    public Icon getDescriptionIcon() {
        return ImageProvider.get((String)"dialogs", (String)"delete");
    }

    public Collection<OsmPrimitive> getParticipatingPrimitives() {
        return this.objects;
    }
}

